/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.api.utils;

import eu.pb4.mapcanvas.api.core.CombinedPlayerCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.impl.MapIdManager;
import eu.pb4.mapcanvas.impl.PlayerInterface;
import eu.pb4.mapcanvas.mixin.EntityAccessor;
import eu.pb4.mapcanvas.mixin.ItemFrameEntityAccessor;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2716;
import net.minecraft.class_2739;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_5536;
import net.minecraft.class_8042;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract sealed class VirtualDisplay {
    private final IntList ids = new IntArrayList();
    private final List<Holder> holders = new ArrayList<Holder>();
    private final Int2ObjectMap<Holder> holderById = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<Holder> clickableHolderById = new Int2ObjectOpenHashMap();
    private final boolean glowing;
    private final class_2338 pos;
    private final class_2350 direction;
    private final int rotation;
    private final DisplayInteractionCallback interactionCallback;
    private final Set<class_3222> players = new HashSet<class_3222>();
    private final boolean invisible;
    private final ClickDetection clickDetection;
    private final IntList clickableIds = new IntArrayList();
    private class_238 box;

    protected VirtualDisplay(class_2338 pos, boolean glowing, class_2350 direction, int rotation, boolean invisible, ClickDetection clickDetection, DisplayInteractionCallback callback) {
        this.glowing = glowing;
        this.pos = pos;
        this.direction = direction;
        this.rotation = rotation;
        this.invisible = invisible;
        this.interactionCallback = callback;
        this.clickDetection = clickDetection;
    }

    @Deprecated(forRemoval=true)
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(PlayerCanvas canvas, class_2338 pos, class_2350 direction) {
        return new Builder().canvas(canvas).pos(pos).direction(direction);
    }

    private static <T> T createClass(Class<T> clazz) {
        try {
            return (T)UnsafeAccess.UNSAFE.allocateInstance(clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated(forRemoval=true)
    public static VirtualDisplay of(PlayerCanvas canvas, class_2338 pos, class_2350 direction, int rotation, boolean glowing) {
        return VirtualDisplay.of(canvas, pos, direction, rotation, glowing, null);
    }

    @Deprecated(forRemoval=true)
    public static VirtualDisplay of(PlayerCanvas canvas, class_2338 pos, class_2350 direction, int rotation, boolean glowing, @Nullable TypedInteractionCallback callback) {
        if (canvas instanceof CombinedPlayerCanvas) {
            CombinedPlayerCanvas combinedCanvas = (CombinedPlayerCanvas)canvas;
            return new Combined(combinedCanvas, pos, glowing, direction, Math.abs(rotation % 4), true, callback != null ? ClickDetection.ENTITY : ClickDetection.NONE, callback);
        }
        return new Single(canvas, pos, glowing, direction, Math.abs(rotation % 4), true, callback != null ? ClickDetection.ENTITY : ClickDetection.NONE, callback);
    }

    @Deprecated(forRemoval=true)
    public static VirtualDisplay of(PlayerCanvas canvas, class_2338 pos, class_2350 direction, int rotation, boolean glowing, @Nullable InteractionCallback callback) {
        return VirtualDisplay.of(canvas, pos, direction, rotation, glowing, (TypedInteractionCallback)callback);
    }

    public final void addPlayer(class_3222 player) {
        if (!player.method_14239() && !this.ids.isEmpty()) {
            ArrayList<class_2596<class_2602>> list = new ArrayList<class_2596<class_2602>>();
            for (Holder holder : this.holders) {
                list.add(holder.spawnPacket);
                list.add(holder.trackerPacket);
            }
            player.field_13987.method_14364((class_2596)new class_8042(list));
            this.players.add(player);
            ((PlayerInterface)player).mapcanvas_addDisplay(this.clickableIds, this);
        }
    }

    private class_238 getBox() {
        if (this.box == null && !this.clickableHolderById.isEmpty()) {
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double minZ = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            double maxZ = Double.NEGATIVE_INFINITY;
            for (Holder x : this.clickableHolderById.values()) {
                minX = Math.min(minX, x.box.field_1323);
                minY = Math.min(minY, x.box.field_1322);
                minZ = Math.min(minZ, x.box.field_1321);
                maxX = Math.max(maxX, x.box.field_1320);
                maxY = Math.max(maxY, x.box.field_1325);
                maxZ = Math.max(maxZ, x.box.field_1324);
            }
            this.box = new class_238(minX, minY, minZ, maxX, maxY, maxZ);
        }
        return this.box;
    }

    public final void removePlayer(class_3222 player) {
        if (!player.method_14239() && !this.ids.isEmpty()) {
            player.field_13987.method_14364((class_2596)new class_2716(this.ids));
        }
        this.players.remove(player);
        ((PlayerInterface)player).mapcanvas_removeDisplay(this.clickableIds, this);
    }

    public final void destroy() {
        for (class_3222 player : new ArrayList<class_3222>(this.players)) {
            this.removePlayer(player);
        }
        IntListIterator intListIterator = this.ids.iterator();
        while (intListIterator.hasNext()) {
            int id = (Integer)intListIterator.next();
            MapIdManager.freeEntityId(id);
        }
        this.holders.clear();
        this.ids.clear();
    }

    protected final void addHolder(PlayerCanvas canvas, int xOffset, int yOffset) {
        Holder holder = Holder.ofItemFrame(canvas, xOffset, yOffset, this.pos, this.direction, this.rotation, this.glowing, this.invisible);
        this.holders.add(holder);
        this.ids.add(holder.entityId);
        this.holderById.put(holder.entityId, (Object)holder);
    }

    protected void createInteractions() {
        this.box = null;
        this.clickableIds.clear();
        this.clickableHolderById.clear();
        this.clickableHolderById.putAll(this.holderById);
        this.clickableIds.addAll((IntCollection)this.clickableHolderById.keySet());
    }

    public abstract int getHeight();

    public abstract int getWidth();

    public abstract PlayerCanvas getCanvas();

    @ApiStatus.Internal
    public final void interactAt(class_3222 player, int id, @Nullable class_243 pos, class_1268 hand, ClickType type) {
        if (this.interactionCallback != null && hand == class_1268.field_5808) {
            int y;
            int x;
            int height;
            Holder holder = (Holder)this.clickableHolderById.get(id);
            if (holder == null) {
                return;
            }
            if (this.clickDetection == ClickDetection.RAYCAST) {
                Optional optional;
                double maxDistance = player.method_55755();
                double maxDistanceSqr = maxDistance * maxDistance;
                class_243 min = player.method_5836(0.0f);
                class_243 rotVec = player.method_5828(1.0f);
                class_243 max = min.method_1031(rotVec.field_1352 * maxDistance, rotVec.field_1351 * maxDistance, rotVec.field_1350 * maxDistance);
                class_238 box2 = this.getBox();
                if (this.invisible) {
                    box2 = box2.method_989((double)this.direction.method_10148() * -0.0625, (double)this.direction.method_10164() * -0.0625, (double)this.direction.method_10165() * -0.0625);
                }
                if ((optional = box2.method_992(min, max)).isPresent()) {
                    class_243 vec3d2 = (class_243)optional.get();
                    double f = min.method_1025(vec3d2);
                    if (f < maxDistanceSqr || maxDistanceSqr == 0.0) {
                        pos = vec3d2.method_1020(box2.method_1005());
                    }
                } else {
                    return;
                }
            }
            if (pos == null) {
                pos = class_243.field_1353;
            }
            int width = this.rotation == 1 || this.rotation == 3 ? this.getHeight() : this.getWidth();
            int n = height = this.rotation == 1 || this.rotation == 3 ? this.getWidth() : this.getHeight();
            if (this.clickDetection == ClickDetection.ENTITY) {
                if (this.direction.method_10166() != class_2350.class_2351.field_11052) {
                    dir = this.direction.method_10160();
                    x = (int)((double)holder.xOffset + (pos.field_1352 * (double)dir.method_10148() + pos.field_1350 * (double)dir.method_10165()) / 0.0625 * 8.0 + 4.0);
                    y = (int)((double)holder.yOffset + ((double)height - pos.field_1351) * 128.0);
                } else {
                    x = (int)((double)holder.xOffset + pos.field_1352 * 128.0) + 64;
                    y = (int)((double)holder.yOffset + pos.field_1350 * 128.0) + 64;
                    if (this.direction == class_2350.field_11033) {
                        y = height * 128 - y;
                    }
                }
            } else if (this.direction.method_10166() != class_2350.class_2351.field_11052) {
                dir = this.direction.method_10160();
                x = (int)((pos.field_1352 * (double)dir.method_10148() + pos.field_1350 * (double)dir.method_10165()) * 128.0) + width * 64;
                y = (int)(-pos.field_1351 * 128.0) + height * 64;
            } else {
                x = (int)(pos.field_1352 * 128.0) + width * 64;
                y = (int)(pos.field_1350 * 128.0) + height * 64;
                if (this.direction == class_2350.field_11033) {
                    y = height * 128 - y;
                }
            }
            if (this.rotation == 1) {
                int tmp = x;
                x = y;
                y = width * 128 - tmp;
            } else if (this.rotation == 2) {
                x = width * 128 - x;
                y = height * 128 - y;
            } else if (this.rotation == 3) {
                int tmp = y;
                y = x;
                x = height * 128 - tmp;
            }
            this.interactionCallback.onClick(player, type, x, y);
        }
    }

    public static interface DisplayInteractionCallback {
        public void onClick(class_3222 var1, ClickType var2, int var3, int var4);
    }

    protected static enum ClickDetection {
        NONE,
        ENTITY,
        RAYCAST;

    }

    public static final class Builder {
        private PlayerCanvas canvas;
        private class_2338 pos;
        private class_2350 direction;
        private boolean glowing;
        private boolean invisible;
        private int rotation = 0;
        private ClickDetection clickDetection = ClickDetection.NONE;
        private DisplayInteractionCallback callback;

        private Builder() {
        }

        public Builder canvas(PlayerCanvas canvas) {
            this.canvas = canvas;
            return this;
        }

        public Builder pos(class_2338 pos) {
            this.pos = pos;
            return this;
        }

        public Builder direction(class_2350 direction) {
            this.direction = direction;
            return this;
        }

        public Builder rotation(class_2470 rotation) {
            this.rotation = rotation.method_10502(0, 4);
            return this;
        }

        public Builder glowing() {
            this.glowing = true;
            return this;
        }

        public Builder glowing(boolean value) {
            this.glowing = value;
            return this;
        }

        public Builder invisible(boolean value) {
            this.invisible = value;
            return this;
        }

        public Builder invisible() {
            this.invisible = true;
            return this;
        }

        public Builder raycast() {
            this.clickDetection = ClickDetection.RAYCAST;
            return this;
        }

        public Builder raycastClickDetection() {
            this.clickDetection = ClickDetection.RAYCAST;
            return this;
        }

        public Builder entityClickDetection() {
            this.clickDetection = ClickDetection.ENTITY;
            return this;
        }

        public Builder type(boolean invisible, boolean glowing) {
            this.invisible = invisible;
            this.glowing = glowing;
            return this;
        }

        public Builder interactionCallback(DisplayInteractionCallback callback) {
            this.callback = callback;
            if (this.clickDetection == ClickDetection.NONE) {
                this.clickDetection = ClickDetection.RAYCAST;
            }
            return this;
        }

        @Deprecated(forRemoval=true)
        public Builder callback(TypedInteractionCallback callback) {
            this.callback = callback;
            if (this.clickDetection == ClickDetection.NONE) {
                this.clickDetection = ClickDetection.ENTITY;
            }
            return this;
        }

        public VirtualDisplay build() {
            PlayerCanvas playerCanvas = this.canvas;
            if (playerCanvas instanceof CombinedPlayerCanvas) {
                CombinedPlayerCanvas combinedCanvas = (CombinedPlayerCanvas)playerCanvas;
                return new Combined(combinedCanvas, this.pos, this.glowing, this.direction, this.rotation, this.invisible, this.clickDetection, this.callback);
            }
            return new Single(this.canvas, this.pos, this.glowing, this.direction, this.rotation, this.invisible, this.clickDetection, this.callback);
        }
    }

    @Deprecated(forRemoval=true)
    public static interface InteractionCallback
    extends TypedInteractionCallback {
        public void onClick(class_3222 var1, int var2, int var3);

        @Override
        default public void onClick(class_3222 player, ClickType type, int x, int y) {
            if (type == ClickType.RIGHT) {
                this.onClick(player, x, y);
            }
        }
    }

    protected static final class Combined
    extends VirtualDisplay {
        private final int width;
        private final int height;
        private final CombinedPlayerCanvas canvas;

        private Combined(CombinedPlayerCanvas canvas, class_2338 pos, boolean glowing, class_2350 direction, int rotation, boolean invisible, ClickDetection clickDetection, DisplayInteractionCallback callback) {
            super(pos, glowing, direction, rotation, invisible, clickDetection, callback);
            this.width = canvas.getSectionsWidth();
            this.height = canvas.getSectionsHeight();
            this.canvas = canvas;
            for (int x = 0; x < this.width; ++x) {
                for (int y = 0; y < this.height; ++y) {
                    this.addHolder(this.canvas.getSubCanvas(x, y), x, y);
                }
            }
            if (clickDetection != ClickDetection.NONE) {
                this.createInteractions();
            }
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public PlayerCanvas getCanvas() {
            return this.canvas;
        }
    }

    protected static final class Single
    extends VirtualDisplay {
        private final PlayerCanvas canvas;

        private Single(PlayerCanvas canvas, class_2338 pos, boolean glowing, class_2350 direction, int rotation, boolean invisible, ClickDetection clickDetection, DisplayInteractionCallback callback) {
            super(pos, glowing, direction, rotation, invisible, clickDetection, callback);
            this.canvas = canvas;
            this.addHolder(this.canvas, 0, 0);
            if (clickDetection != ClickDetection.NONE) {
                this.createInteractions();
            }
        }

        @Override
        public int getHeight() {
            return 1;
        }

        @Override
        public int getWidth() {
            return 1;
        }

        @Override
        public PlayerCanvas getCanvas() {
            return this.canvas;
        }
    }

    @Deprecated(forRemoval=true)
    public static interface TypedInteractionCallback
    extends DisplayInteractionCallback {
        public void onClick(class_3222 var1, class_5536 var2, int var3, int var4);

        @Override
        default public void onClick(class_3222 player, ClickType type, int x, int y) {
            this.onClick(player, type == ClickType.RIGHT ? class_5536.field_27014 : class_5536.field_27013, x, y);
        }
    }

    protected record Holder(int entityId, int xOffset, int yOffset, class_243 pos, class_238 box, UUID uuid, class_2596<class_2602> spawnPacket, class_2596<class_2602> trackerPacket) {
        public static Holder ofItemFrame(PlayerCanvas canvas, int xOffset, int yOffset, class_2338 pos, class_2350 direction, int rotation, boolean glowing, boolean visible) {
            int z;
            int y;
            int x;
            int finalXOffset = xOffset;
            int finalYOffset = yOffset;
            switch (rotation) {
                case 1: {
                    x = xOffset;
                    xOffset = -yOffset;
                    yOffset = x;
                    break;
                }
                case 2: {
                    xOffset = -xOffset;
                    yOffset = -yOffset;
                    break;
                }
                case 3: {
                    x = -xOffset;
                    xOffset = yOffset;
                    yOffset = x;
                }
            }
            if (direction.method_10166().method_10179()) {
                x = xOffset * direction.method_10165();
                y = -yOffset;
                z = -xOffset * direction.method_10148();
            } else {
                x = xOffset;
                y = 0;
                z = yOffset * direction.method_10164();
            }
            int entityId = MapIdManager.requestEntityId();
            UUID uuid = UUID.randomUUID();
            class_243 entPos = class_243.method_24953((class_2382)pos).method_1031((double)x, (double)y, (double)z);
            class_2604 spawnPacket = new class_2604(entityId, uuid, entPos.method_10216(), entPos.method_10214(), entPos.method_10215(), 0.0f, 0.0f, glowing ? class_1299.field_28401 : class_1299.field_6043, direction.method_10146(), class_243.field_1353, 0.0);
            class_2739 trackerPacket = new class_2739(entityId, List.of(class_2945.class_7834.method_46360(ItemFrameEntityAccessor.getItemStack(), (Object)canvas.asStack()), class_2945.class_7834.method_46360(ItemFrameEntityAccessor.getRotation(), (Object)rotation), class_2945.class_7834.method_46360(EntityAccessor.getFlags(), (Object)((byte)((visible ? 1 : 0) << 5)))));
            class_243 boxCenter = entPos.method_43206(direction, -0.46875);
            class_2350.class_2351 axis = direction.method_10166();
            double dx = axis == class_2350.class_2351.field_11048 ? 0.0625 : 1.0;
            double dy = axis == class_2350.class_2351.field_11052 ? 0.0625 : 1.0;
            double dz = axis == class_2350.class_2351.field_11051 ? 0.0625 : 1.0;
            return new Holder(entityId, finalXOffset, finalYOffset, entPos, class_238.method_30048((class_243)boxCenter, (double)dx, (double)dy, (double)dz), UUID.randomUUID(), (class_2596<class_2602>)spawnPacket, (class_2596<class_2602>)trackerPacket);
        }
    }

    public static enum ClickType {
        LEFT,
        RIGHT,
        MIDDLE,
        MIDDLE_CTRL;


        public boolean isLeft() {
            return this == LEFT;
        }

        public boolean isRight() {
            return this == RIGHT;
        }

        public boolean isMiddle() {
            return this == MIDDLE || this == MIDDLE_CTRL;
        }
    }
}

