/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl;

import eu.pb4.mapcanvas.api.core.CanvasIcon;
import eu.pb4.mapcanvas.api.core.CombinedPlayerCanvas;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import eu.pb4.mapcanvas.api.core.PlayerCanvas;
import eu.pb4.mapcanvas.impl.AbstractPlayerMapCanvas;
import eu.pb4.mapcanvas.impl.MapIdManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3244;
import net.minecraft.class_6880;
import net.minecraft.class_9209;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public final class MultiMapCanvasImpl
implements CombinedPlayerCanvas {
    private int width;
    private int height;
    private MapCanvasPart[] parts;
    private final Set<WrappedMapIcon> icons = new HashSet<WrappedMapIcon>();
    private final Set<class_3244> players = Collections.synchronizedSet(new HashSet());

    public MultiMapCanvasImpl(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public int getIdOf(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            return this.parts[x + y * this.width].getId();
        }
        return 0;
    }

    @Override
    public class_1799 asStackOf(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            return this.parts[x + y * this.width].asStack();
        }
        return new class_1799((class_1935)class_1802.field_8204);
    }

    @Override
    @Nullable
    public PlayerCanvas getSubCanvas(int x, int y) {
        if (x < this.width && y < this.height && x >= 0 && y >= 0) {
            return this.parts[x + y * this.width];
        }
        return null;
    }

    @Override
    public int getSectionsWidth() {
        return this.width;
    }

    @Override
    public int getSectionsHeight() {
        return this.height;
    }

    @Override
    public void resize(int width, int height) {
        MapCanvasPart[] oldParts = this.parts;
        this.width = width;
        this.height = height;
        this.parts = new MapCanvasPart[width * height];
        if (oldParts != null) {
            for (MapCanvasPart path : oldParts) {
                if (path.x >= width || path.y >= height) continue;
                this.parts[path.x + path.y * width] = path;
            }
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int i = x + y * width;
                if (this.parts[i] != null) continue;
                MapCanvasPart part = new MapCanvasPart(MapIdManager.requestMapId());
                part.x = x;
                part.y = y;
                this.parts[i] = part;
            }
        }
    }

    @Override
    public byte getRaw(int x, int y) {
        int xI = x / 128;
        int yI = y / 128;
        if (xI < this.width && yI < this.height && xI >= 0 && yI >= 0) {
            return this.parts[xI + yI * this.width].getRaw(x - xI * 128, y - yI * 128);
        }
        return 0;
    }

    @Override
    public void setRaw(int x, int y, byte color) {
        int xI = x / 128;
        int yI = y / 128;
        if (xI < this.width && yI < this.height && xI >= 0 && yI >= 0) {
            this.parts[xI + yI * this.width].setRaw(x - xI * 128, y - yI * 128, color);
        }
    }

    @Override
    public void fillRaw(byte color) {
        for (MapCanvasPart part : this.parts) {
            part.fillRaw(color);
        }
    }

    @Override
    public int getHeight() {
        return this.height * 128;
    }

    @Override
    public int getWidth() {
        return this.width * 128;
    }

    @Override
    public CanvasIcon createIcon(class_6880<class_9428> type, boolean visible, int x, int y, byte rotation, @Nullable class_2561 text) {
        int canvasX = x / 256;
        int canvasY = y / 256;
        WrappedMapIcon icon = new WrappedMapIcon(this.getSubCanvas(canvasX, canvasY).createIcon(type, visible, x % 256, y % 256, rotation, text), canvasX, canvasY);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public CanvasIcon createIcon() {
        WrappedMapIcon icon = new WrappedMapIcon(this.parts[0].createIcon(), 0, 0);
        this.icons.add(icon);
        return icon;
    }

    @Override
    public void removeIcon(CanvasIcon icon) {
        if (this.icons.remove(icon) && icon instanceof WrappedMapIcon) {
            WrappedMapIcon wrappedMapIcon = (WrappedMapIcon)icon;
            wrappedMapIcon.icon.remove();
        }
    }

    @Override
    public Collection<CanvasIcon> getIcons() {
        return Collections.unmodifiableCollection(this.icons);
    }

    @Override
    public boolean addPlayer(class_3244 player) {
        if (this.isDestroyed()) {
            return false;
        }
        if (this.players.add(player)) {
            for (MapCanvasPart part : this.parts) {
                part.sendFull(player);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removePlayer(class_3244 player) {
        return this.players.remove(player);
    }

    @Override
    public void sendUpdates() {
        for (MapCanvasPart part : this.parts) {
            part.sendUpdates();
        }
    }

    @Override
    public boolean isDirty() {
        for (MapCanvasPart parts : this.parts) {
            if (!parts.isDirty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_9209 getIdComponent() {
        return null;
    }

    @Override
    public void destroy() {
        if (this.isDestroyed()) {
            return;
        }
        for (class_3244 player : new ArrayList<class_3244>(this.players)) {
            this.removePlayer(player);
        }
        for (MapCanvasPart part : this.parts) {
            part.destroy();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.parts[0].isDestroyed();
    }

    private final class MapCanvasPart
    extends AbstractPlayerMapCanvas {
        protected int x;
        protected int y;

        public MapCanvasPart(int id) {
            super(id);
            this.x = 0;
            this.y = 0;
        }

        @Override
        protected Collection<class_3244> getPlayers() {
            return MultiMapCanvasImpl.this.players;
        }
    }

    private final class WrappedMapIcon
    implements CanvasIcon {
        public int y;
        public int x;
        public CanvasIcon icon;

        protected WrappedMapIcon(CanvasIcon icon, int x, int y) {
            this.icon = icon;
            this.x = x;
            this.y = y;
        }

        @Override
        public class_6880<class_9428> getType() {
            return this.icon.getType();
        }

        @Override
        public void setType(class_6880<class_9428> type) {
            this.icon.setType(type);
        }

        @Override
        public int getX() {
            return this.icon.getX() + this.x * 256;
        }

        @Override
        public int getY() {
            return this.icon.getY() + this.y * 256;
        }

        @Override
        public byte getRotation() {
            return this.icon.getRotation();
        }

        @Override
        public void move(int x, int y, byte rotation) {
            int newX = x / 256;
            int newY = y / 256;
            if (this.x != newX || this.y != newY) {
                this.x = newX;
                this.y = newY;
                this.icon.remove();
                this.icon = MultiMapCanvasImpl.this.getSubCanvas(newX, newY).createIcon(this.icon.getType(), this.icon.isVisible(), x % 256, y % 256, rotation, this.icon.getText());
            } else {
                this.icon.move(x % 256, y % 256, rotation);
            }
        }

        @Override
        public boolean isVisible() {
            return this.icon.isVisible();
        }

        @Override
        public void setVisibility(boolean visibility) {
            this.icon.setVisibility(visibility);
        }

        @Override
        @Nullable
        public class_2561 getText() {
            return this.icon.getText();
        }

        @Override
        public void setText(class_2561 text) {
            this.icon.setText(text);
        }

        public DrawableCanvas getOwningCanvas() {
            return MultiMapCanvasImpl.this;
        }
    }
}

