/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.font.serialization;

import eu.pb4.mapcanvas.api.font.CanvasFont;
import eu.pb4.mapcanvas.impl.font.BitmapFont;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HexFormat;

public class UniHexFontReader {
    public static BitmapFont build(Path hexFile, CanvasFont.Metadata metadata) throws IOException {
        return UniHexFontReader.build(Files.newInputStream(hexFile, new OpenOption[0]), metadata);
    }

    public static BitmapFont build(InputStream hexFile, CanvasFont.Metadata metadata) throws IOException {
        BitmapFont font = new BitmapFont(BitmapFont.Glyph.INVALID, metadata);
        UniHexFontReader.parse(hexFile, font);
        return font;
    }

    private static void parse(InputStream hexFile, BitmapFont font) throws IOException {
        int height = 16;
        while (hexFile.available() > 0) {
            StringBuilder num = new StringBuilder();
            StringBuilder bitmap = new StringBuilder();
            StringBuilder current = num;
            while (true) {
                int chr;
                if ((chr = hexFile.read()) == -1) {
                    if (num != current) break;
                    return;
                }
                if (chr == 10) break;
                if (chr == 58) {
                    current = bitmap;
                    continue;
                }
                current.append((char)chr);
            }
            int codepoint = Integer.parseInt(num.toString(), 16);
            byte[] bytes = HexFormat.of().parseHex(bitmap.toString());
            int width = bytes.length / 2;
            boolean[] texture = new boolean[width * height];
            int realWidth = 0;
            for (int i = 0; i < bytes.length; ++i) {
                int b = Byte.toUnsignedInt(bytes[i]);
                if (b == 0) continue;
                for (int a = 0; a < 8; ++a) {
                    boolean value;
                    boolean bl = value = (b >> a & 1) == 1;
                    if (!value) continue;
                    texture[i * 8 + 7 - a] = true;
                    realWidth = Math.max(realWidth, (i * 8 + a) % width);
                }
            }
            font.characters.put(codepoint, (Object)new BitmapFont.Glyph(width, height, 7, realWidth, 8, texture));
        }
    }
}

