/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.mapcanvas.impl.image;

import eu.pb4.mapcanvas.api.core.CanvasColor;
import eu.pb4.mapcanvas.api.core.CanvasImage;
import eu.pb4.mapcanvas.api.core.DrawableCanvas;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public record RawImage(int[] data, int width, int height) {
    public int get(int x, int y) {
        return this.data[x + y * this.width];
    }

    public int set(int x, int y, int val) {
        int n = val;
        this.data[x + y * this.width] = n;
        return n;
    }

    public static RawImage of(int width, int height) {
        return new RawImage(new int[width * height], width, height);
    }

    public RawImage copy() {
        int[] arr = new int[this.data.length];
        System.arraycopy(this.data, 0, arr, 0, arr.length);
        return new RawImage(arr, this.width, this.height);
    }

    public void fill(int color) {
        Arrays.fill(this.data, color);
    }

    public static RawImage convert(BufferedImage image) {
        int pixels = image.getHeight() * image.getWidth();
        int[] out = new int[pixels];
        image.getRGB(0, 0, image.getWidth(), image.getHeight(), out, 0, image.getWidth());
        return new RawImage(out, image.getWidth(), image.getHeight());
    }

    public static RawImage convert(CanvasImage image) {
        int pixels = image.getHeight() * image.getWidth();
        int[] out = new int[pixels];
        for (int i = 0; i < pixels; ++i) {
            out[i] = CanvasColor.getFromRaw(image.getRawAt(i)).getRgbColor();
        }
        return new RawImage(out, image.getWidth(), image.getHeight());
    }

    public static RawImage convert(DrawableCanvas image) {
        if (image instanceof CanvasImage) {
            CanvasImage canvasImage = (CanvasImage)image;
            return RawImage.convert(canvasImage);
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] out = new int[width * height];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                out[x + y * width] = image.get(x, y).getRgbColor();
            }
        }
        return new RawImage(out, width, height);
    }

    public BufferedImage wrapAsImage() {
        WritableRaster raster = Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, this.width, this.height, new int[]{0xFF0000, 65280, 255, -16777216}), new DataBufferInt(this.data, this.data.length), new Point(0, 0));
        return new BufferedImage(ColorModel.getRGBdefault(), raster, false, null);
    }
}

