/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.api.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.PMI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;

public record JsonCodecDataStorage<T>(String path, Codec<T> codec) implements PlayerDataStorage<T>
{
    @Override
    public boolean save(MinecraftServer server, UUID player, T settings) {
        Path path = PlayerDataApi.getPathFor(server, player);
        if (settings == null) {
            try {
                return Files.deleteIfExists(path.resolve(this.path + ".json"));
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            JsonElement value = (JsonElement)this.codec.encodeStart((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE), settings).result().get();
            Files.writeString(path.resolve(this.path + ".json"), (CharSequence)value.toString(), StandardCharsets.UTF_8, new OpenOption[0]);
            return true;
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't save player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public T load(MinecraftServer server, UUID player) {
        try {
            Path path = PlayerDataApi.getPathFor(server, player).resolve(this.path + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            JsonElement element = JsonParser.parseString((String)Files.readString(path, StandardCharsets.UTF_8));
            return this.codec.decode((DynamicOps)server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE), (Object)element).result().map(Pair::getFirst).orElse(null);
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't load player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return null;
        }
    }
}

