/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.api.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.BaseGson;
import eu.pb4.playerdata.impl.PMI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public record JsonDataStorage<T>(String path, Class<T> clazz, Gson gson) implements PlayerDataStorage<T>
{
    public JsonDataStorage(String path, Class<T> clazz) {
        this(path, clazz, BaseGson.GSON);
    }

    public JsonDataStorage(String path, Class<T> clazz, Function<GsonBuilder, GsonBuilder> builderConsumer) {
        this(path, clazz, builderConsumer.apply(JsonDataStorage.createGsonBuilder()).create());
    }

    public static GsonBuilder createGsonBuilder() {
        return BaseGson.createBuilder();
    }

    @Override
    public boolean save(MinecraftServer server, UUID player, T settings) {
        Path path = PlayerDataApi.getPathFor(server, player);
        if (settings == null) {
            try {
                return Files.deleteIfExists(path.resolve(this.path + ".json"));
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            BaseGson.withRegistries((class_7225.class_7874)server.method_30611());
            Files.writeString(path.resolve(this.path + ".json"), (CharSequence)this.gson.toJson(settings), StandardCharsets.UTF_8, new OpenOption[0]);
            BaseGson.withRegistries(null);
            return true;
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't save player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public T load(MinecraftServer server, UUID player) {
        try {
            Path path = PlayerDataApi.getPathFor(server, player).resolve(this.path + ".json");
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            String json = Files.readString(path, StandardCharsets.UTF_8);
            BaseGson.withRegistries((class_7225.class_7874)server.method_30611());
            Object ret = this.gson.fromJson(json, this.clazz);
            BaseGson.withRegistries(null);
            return (T)ret;
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't load player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return null;
        }
    }
}

