/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.api.storage;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.PMI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.server.MinecraftServer;

public record NbtCodecDataStorage<T>(String path, Codec<T> codec) implements PlayerDataStorage<T>
{
    @Override
    public boolean save(MinecraftServer server, UUID player, T settings) {
        Path path = PlayerDataApi.getPathFor(server, player);
        if (settings == null) {
            try {
                return Files.deleteIfExists(path.resolve(this.path + ".dat"));
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        try {
            class_2487 out;
            Files.createDirectories(path, new FileAttribute[0]);
            class_2520 value = (class_2520)this.codec.encodeStart((DynamicOps)server.method_30611().method_57093((DynamicOps)class_2509.field_11560), settings).result().get();
            if (value instanceof class_2487) {
                class_2487 compound;
                out = compound = (class_2487)value;
            } else {
                out = new class_2487();
                out.method_10566("", value);
            }
            class_2507.method_30614((class_2487)out, (Path)path.resolve(this.path + ".dat"));
            return true;
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't save player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public T load(MinecraftServer server, UUID player) {
        try {
            Path path = PlayerDataApi.getPathFor(server, player).resolve(this.path + ".dat");
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            class_2487 nbt = class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
            Object element = nbt.method_10545("") ? nbt.method_10580("") : nbt;
            return this.codec.decode((DynamicOps)server.method_30611().method_57093((DynamicOps)class_2509.field_11560), element).result().map(Pair::getFirst).orElse(null);
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't load player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return null;
        }
    }
}

