/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.api.storage;

import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.PMI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.server.MinecraftServer;

public record NbtDataStorage(String path) implements PlayerDataStorage<class_2487>
{
    @Override
    public boolean save(MinecraftServer server, UUID player, class_2487 settings) {
        Path path = PlayerDataApi.getPathFor(server, player);
        if (settings == null) {
            try {
                return Files.deleteIfExists(path.resolve(this.path + ".dat"));
            }
            catch (Throwable ignored) {
                return false;
            }
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            class_2507.method_30614((class_2487)settings, (Path)path.resolve(this.path + ".dat"));
            return true;
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't save player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public class_2487 load(MinecraftServer server, UUID player) {
        try {
            Path path = PlayerDataApi.getPathFor(server, player).resolve(this.path + ".dat");
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            return class_2507.method_30613((Path)path, (class_2505)class_2505.method_53898());
        }
        catch (Exception e) {
            PMI.LOGGER.error(String.format("Couldn't load player data of %s for path %s", player, this.path));
            e.printStackTrace();
            return null;
        }
    }
}

