/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.playerdata.mixin;

import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.playerdata.api.storage.PlayerDataStorage;
import eu.pb4.playerdata.impl.PMI;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3324.class}, priority=500)
public class PlayerListMixin
implements PMI {
    @Unique
    private final Map<UUID, Map<PlayerDataStorage<Object>, Object>> pda_playerDataMap = new Object2ObjectOpenHashMap();

    @Inject(method={"method_14570(Lnet/minecraft/class_2535;Lnet/minecraft/class_3222;Lnet/minecraft/class_8792;)V"}, at={@At(value="HEAD")})
    private void loadData(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        for (PlayerDataStorage storage : PlayerDataApi.getDataStorageSet()) {
            try {
                map.put((Object)storage, storage.load(player));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.pda_playerDataMap.put(player.method_5667(), (Map<PlayerDataStorage<Object>, Object>)map);
    }

    @Inject(method={"method_14577(Lnet/minecraft/class_3222;)V"}, at={@At(value="HEAD")})
    private void pda_saveData(class_3222 player, CallbackInfo ci) {
        Map<PlayerDataStorage<Object>, Object> map = this.pda_playerDataMap.get(player.method_5667());
        if (map != null) {
            for (Map.Entry<PlayerDataStorage<Object>, Object> entry : map.entrySet()) {
                try {
                    entry.getKey().save(player, entry.getValue());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Inject(method={"method_14611(Lnet/minecraft/class_3222;)V"}, at={@At(value="TAIL")})
    private void pda_dontHoldOfflineData(class_3222 player, CallbackInfo ci) {
        this.pda_playerDataMap.remove(player.method_5667());
    }

    @Override
    public Map<PlayerDataStorage<Object>, Object> pda_getStorageMap(UUID uuid) {
        return this.pda_playerDataMap.get(uuid);
    }

    @Override
    public <T> T pda_getStorageValue(UUID uuid, PlayerDataStorage<T> storage) {
        Map<PlayerDataStorage<Object>, Object> map = this.pda_playerDataMap.get(uuid);
        if (map != null) {
            return (T)map.get(storage);
        }
        return null;
    }

    @Override
    public <T> void pda_setStorageValue(UUID uuid, PlayerDataStorage<T> storage, T value) {
        Map<PlayerDataStorage<Object>, Object> map = this.pda_playerDataMap.get(uuid);
        if (map != null) {
            map.put(storage, value);
        }
    }

    @Override
    public boolean pda_isStored(UUID uuid) {
        return this.pda_playerDataMap.containsKey(uuid);
    }
}

