package eu.pb4.polymer.autohost.impl.providers;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import eu.pb4.polymer.autohost.api.AutoHostUtils;
import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.minecraft.class_2535;
import net.minecraft.server.MinecraftServer;
import org.apache.http.HttpStatus;
import org.jetbrains.annotations.Nullable;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.util.concurrent.Executors;

public class StandaloneWebServerProvider extends AbstractProvider  {
    private Config config;
    private HttpServer server;
    public String baseAddress = "";

    @Nullable
    public void serverStarted(MinecraftServer minecraftServer) {
        try {
            var address = createBindAddress(minecraftServer, config);
            server = HttpServer.create(address, 0);

            server.createContext("/", this::handle);
            server.setExecutor(Executors.newFixedThreadPool(2));
            server.start();

            this.baseAddress = config.externalAddress;
            if (!this.baseAddress.endsWith("/")) {
                this.baseAddress += "/";
            }

            super.serverStarted(minecraftServer);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Nullable
    public void serverStopped(MinecraftServer minecraftServer) {
        if (server != null) {
            server.stop(0);
        }
    }

    protected boolean updateHash() {
        if (super.updateHash()) {
            return true;
        }
        return false;
    }

    @Override
    protected String getAddress(class_2535 connection, String file) {
        return this.baseAddress + file;
    }

    private static InetSocketAddress createBindAddress(MinecraftServer server, Config config) {
        var serverIp = server.method_3819();
        if (!Strings.isNullOrEmpty(serverIp)) {
            return new InetSocketAddress(serverIp, config.port);
        } else {
            return new InetSocketAddress(config.port);
        }
    }


    public void handle(HttpExchange exchange) throws IOException {
        if ("GET".equals(exchange.getRequestMethod())) {
            var path = AutoHost.getPath(exchange.getRequestURI().getPath().substring(1));

            if (Files.exists(path)) {
                var updateTime = Files.getLastModifiedTime(path).toMillis();
                if (updateTime > lastUpdate) {
                    updateHash();
                }

                try (
                        var input = Files.newInputStream(PolymerResourcePackUtils.getMainPath());
                        var output = exchange.getResponseBody()
                ) {
                    exchange.getResponseHeaders().add("Server", "polymer-autohost");
                    exchange.getResponseHeaders().add("Content-Type", "application/zip");
                    exchange.getResponseHeaders().add("Cache-Control", "public, max-age=" + AutoHost.config.cacheControlAge);
                    exchange.sendResponseHeaders(HttpStatus.SC_OK, size);

                    input.transferTo(output);
                    output.flush();
                }
            }
         }
    }

    @Override
    public JsonElement saveSettings() {
        return this.config.toJson();
    }

    @Override
    public void loadSettings(JsonElement settings) {
        this.config = CommonImpl.GSON.fromJson(settings, Config.class);
        if (this.config == null) {
            this.config = new Config();
        }
    }

    public static class Config {
        public String _c1 = "Port used internally to run http server";
        public int port = 25567;
        public String _c2 = "Public address used for sending requests";
        @SerializedName(value = "external_address", alternate = {"forced_address", "address"})
        public String externalAddress = "http://localhost:25567/";

        public JsonElement toJson() {
            return CommonImpl.GSON.toJsonTree(this);
        }
    }
}