package eu.pb4.polymer.autohost.mixin;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.autohost.impl.AutoHostTask;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.minecraft.class_11560;
import net.minecraft.class_2535;
import net.minecraft.class_2856;
import net.minecraft.class_8605;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8612;
import net.minecraft.class_8792;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.*;

@Mixin(class_8610.class)
public abstract class ServerConfigurationNetworkHandlerMixin extends class_8609 {
    public ServerConfigurationNetworkHandlerMixin(MinecraftServer server, class_2535 connection, class_8792 clientData) {
        super(server, connection, clientData);
    }

    @Shadow @Final private Queue<class_8605> tasks;

    @Shadow @Nullable private class_8605 currentTask;

    @Shadow protected abstract void onTaskFinished(class_8605.class_8606 key);

    @Shadow protected abstract GameProfile method_52403();

    @Inject(method = "queueSendResourcePackTask", at = @At("TAIL"))
    private void polymerAutoHost$addTask(CallbackInfo ci) {
        if (AutoHost.config.enabled && !this.field_45012.method_19466(new class_11560(this.method_52403()))) {
            var x = new ArrayList<MinecraftServer.class_7460>();
            var ready = AutoHost.provider.isReady();
            if (ready) {
                x.addAll(AutoHost.provider.getProperties(this.field_45013));
            }
            x.addAll(AutoHost.GLOBAL_RESOURCE_PACKS);

            this.tasks.add(new AutoHostTask(x, !ready, () -> AutoHost.provider.getProperties(this.field_45013), AutoHost.provider::isReady));
        }
    }

    @Inject(method = "onResourcePackStatus", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerCommonNetworkHandler;onResourcePackStatus(Lnet/minecraft/network/packet/c2s/common/ResourcePackStatusC2SPacket;)V", shift = At.Shift.AFTER), cancellable = true)
    private void onStatus(class_2856 packet, CallbackInfo ci) {
        if (this.currentTask instanceof AutoHostTask task) {
            if (task.onStatus((class_8610) (Object) this, packet.comp_2163(), packet.comp_2164())) {
                this.onTaskFinished(AutoHostTask.KEY);
            }
            ci.cancel();
        }
    }

    @Inject(method = "tick", at = @At("TAIL"))
    private void tickTask(CallbackInfo ci) {
        if (this.currentTask instanceof AutoHostTask task) {
            task.tick(this::method_14364);
        }
    }

    @WrapWithCondition(method = "onResourcePackStatus", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/network/ServerConfigurationNetworkHandler;onTaskFinished(Lnet/minecraft/server/network/ServerPlayerConfigurationTask$Key;)V"))
    private boolean checkType(class_8610 instance, class_8605.class_8606 key, @Local class_2856 packet) {
        return key != class_8612.field_45034
                || (this.field_45012.method_43659().isPresent() && this.field_45012.method_43659().get().comp_2156().equals(packet.comp_2163()));
    }
}
