package eu.pb4.polymer.autohost.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;

public interface ResourcePackDataProvider {
    boolean isReady();
    JsonElement saveSettings();
    void loadSettings(JsonElement settings);
    void serverStarted(MinecraftServer server);
    void serverStopped(MinecraftServer server);

    static ResourcePackDataProvider getActive() {
        return AutoHost.provider;
    }

    static <T> void register(class_2960 identifier, Supplier<ResourcePackDataProvider> providerCreator) {
        AutoHost.TYPES.put(identifier, providerCreator);
    }

    Collection<MinecraftServer.class_7460> getProperties(class_2535 connection);

    String getMainFilePath(PacketContext context);
    String getFilePath(PacketContext context, class_2960 identifier);

    default String getFilePath(PacketContext context, class_2960 identifier, @Nullable String hash) {
        return this.getFilePath(context, identifier);
    }

    default MinecraftServer.class_7460 createProperties(PacketContext context, class_2960 address) {
        return this.createProperties(context,null, address, null);
    }

    default MinecraftServer.class_7460 createProperties(PacketContext context, class_2960 address, @Nullable String hash) {
        return this.createProperties(context,null, address, hash);
    }

    default MinecraftServer.class_7460 createProperties(PacketContext context, @Nullable UUID uuid, class_2960 address, @Nullable String hash) {
        return createProperties(uuid, this.getFilePath(context, address), hash);
    }

    static MinecraftServer.class_7460 createProperties(String address) {
        return createProperties(null, address, null);
    }

    static MinecraftServer.class_7460 createProperties(String address, @Nullable String hash) {
        return createProperties(null, address, hash);
    }

    static MinecraftServer.class_7460 createProperties(@Nullable UUID uuid, String address, @Nullable String hash) {
        return new MinecraftServer.class_7460(
                uuid != null ? uuid : UUID.nameUUIDFromBytes(address.getBytes(StandardCharsets.UTF_8)),
                address,
                hash != null ? hash : "",
                AutoHost.config.require || (AutoHost.config.modOverride && PolymerResourcePackUtils.isRequired()),
                AutoHost.message
        );
    }
}
