package eu.pb4.polymer.autohost.impl;

import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import net.minecraft.class_11406;
import net.minecraft.class_11407;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11428;
import net.minecraft.class_11432;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_11524;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_9053;
import net.minecraft.dialog.*;
import net.minecraft.server.MinecraftServer;
import java.util.*;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AutoHostTask implements class_8605 {
    public static final class_8606 KEY = new class_8606("polymer:autohost/send_packs");
    public static final class_2960 DISCONNECT = class_2960.method_60654("polymer:autohost/disconnect");
    private final Collection<MinecraftServer.class_7460> packs;

    private final Set<UUID> requiredPacks = new HashSet<>();
    private final Set<UUID> waitingFor = new HashSet<>();
    private final Supplier<Collection<MinecraftServer.class_7460>> delayed;
    private final BooleanSupplier isReady;
    private boolean hasDelayed;
    private int statusCount = -1;
    private int tick = 0;

    public AutoHostTask(Collection<MinecraftServer.class_7460> properties, boolean hasDelayed,
                        Supplier<Collection<MinecraftServer.class_7460>> delayed, BooleanSupplier isReady) {
        this.packs = properties;
        for (var pack : packs) {
            if (pack.comp_786()) {
                requiredPacks.add(pack.comp_2156());
            }
            waitingFor.add(pack.comp_2156());
        }
        this.hasDelayed = hasDelayed;
        this.delayed = delayed;
        this.isReady = isReady;
    }

    @Override
    public void method_52376(Consumer<class_2596<?>> sender) {
        if (AutoHost.config.clearResourcePacks) {
            sender.accept(new class_9053(Optional.empty()));
        }

        if (this.hasDelayed) {
            this.sendDialog(sender);
            return;
        }
        for (var pack : packs) {
            sender.accept(new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
        }
    }

    private void sendDialog(Consumer<class_2596<?>> sender) {
        if (!AutoHost.config.dialog) {
            return;
        }

        var list = new ArrayList<class_11432>(4);

        list.add(new class_11435(AutoHost.dialogHeader, 300));

        if (AutoHost.config.dialogShowDots) {
            var sb = new StringBuilder();
            var index = ((this.tick - 1) / 2) % 10;

            if (((this.tick - 1) / 2) % 20 >= 10) {
                index = 9 - index;
            }

            for (int i = 1; i < index; i++) {
                sb.append('_');
            }

            if (index > 0) {
                sb.append('o');
            }

            sb.append('O');

            if (sb.length() < 10) {
                sb.append('o');
                while (sb.length() < 10) {
                    sb.append('_');
                }
            }

            list.add(new class_11435(class_2561.method_43470(sb.toString()).method_27692(class_124.field_1080), 200));
        }

        list.add(new class_11435(PolymerResourcePackMod.STATUS.isEmpty() || !AutoHost.config.dialogShowStatus ? AutoHost.dialogDefaultBody :
                class_2561.method_43470(String.join("\n", PolymerResourcePackMod.STATUS
                        .subList(Math.max(PolymerResourcePackMod.STATUS.size() - 6, 0), PolymerResourcePackMod.STATUS.size()))), 300));

        this.statusCount = PolymerResourcePackMod.STATUS.size();
        sender.accept(new class_11407(class_6880.method_40223(new class_11428(
                new class_11417(AutoHost.dialogTitle, Optional.empty(),false, false, class_11520.field_60962,
                        list, List.of()),
                new class_11519(new class_11416(
                        class_2561.method_43471("menu.disconnect"), 150),
                        Optional.of(new class_11524(DISCONNECT, Optional.empty())))
        ))));
    }

    public void tick(Consumer<class_2596<?>> sender) {
        if (this.hasDelayed && this.isReady.getAsBoolean()) {
            if (AutoHost.config.dialog) {
                sender.accept(class_11406.field_60602);
            }
            var delayed = this.delayed.get();
            for (var pack : delayed) {
                if (pack.comp_786()) {
                    requiredPacks.add(pack.comp_2156());
                }
                waitingFor.add(pack.comp_2156());
            }
            for (var pack : packs) {
                sender.accept(new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
            }
            for (var pack : delayed) {
                sender.accept(new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
            }
            this.hasDelayed = false;
        } else if (this.hasDelayed && ++this.tick % 2 == 0) {
            sendDialog(sender);
        }
    }

    @Override
    public class_8606 method_52375() {
        return KEY;
    }

    public boolean onStatus(class_8610 handler, UUID id, class_2856.class_2857 status) {
        switch (status) {
            case field_13018, field_47668, field_13015, field_47667 -> {
                if (this.requiredPacks.contains(id)) {
                    handler.method_52396(class_2561.method_43471("multiplayer.requiredTexturePrompt.disconnect"));
                }
            }
        }

        if (status.method_55627()) {
            this.waitingFor.remove(id);
        }

        return this.waitingFor.isEmpty() && !this.hasDelayed;
    }
}
