package eu.pb4.polymer.autohost.impl;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.autohost.api.AutoHostUtils;
import eu.pb4.polymer.autohost.api.ResourcePackDataProvider;
import eu.pb4.polymer.autohost.impl.providers.*;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_2720;
import net.minecraft.class_2960;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.nio.file.Path;
import java.util.*;
import java.util.function.Supplier;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class AutoHost implements ModInitializer {
    public static final Map<class_2960, Supplier<ResourcePackDataProvider>> TYPES = new HashMap<>();
    public static final List<MinecraftServer.class_7460> GLOBAL_RESOURCE_PACKS = new ArrayList<>();
    public static final Map<String, Path> FILES = new HashMap<>();
    public static AutoHostConfig config = new AutoHostConfig();
    public static class_2561 message = class_2561.method_43473();
    public static class_2561 disconnectMessage = class_2561.method_43473();
    public static class_2561 dialogTitle = class_2561.method_43473();
    public static class_2561 dialogDefaultBody = class_2561.method_43473();
    public static class_2561 dialogHeader = class_2561.method_43473();
    public static ResourcePackDataProvider provider = EmptyProvider.INSTANCE;

    public static final String DEFAULT_PATH = AutoHostUtils.getPathFromId(AutoHostUtils.DEFAULT_PACK_ID);
    public static boolean generateWhenDisabled = false;

    public static void init(MinecraftServer server) {
        var config = CommonImpl.loadConfig("auto-host", AutoHostConfig.class);
        AutoHost.config = config;

        if (!config.enabled) {
            if (generateWhenDisabled) {
                EmptyProvider.INSTANCE.serverStarted(server);
            }
            return;
        }

        try {
            AutoHost.message = class_8824.field_46597.decode(JsonOps.INSTANCE, AutoHost.config.message).getOrThrow().getFirst();
        } catch (Exception e) {
            AutoHost.message = null;
        }

        try {
            AutoHost.disconnectMessage = class_8824.field_46597.decode(JsonOps.INSTANCE, AutoHost.config.disconnectMessage).getOrThrow().getFirst();
        } catch (Exception e) {
            AutoHost.disconnectMessage = class_2561.method_43470("This server requires resource pack enabled to play!");
        }

        try {
            AutoHost.dialogTitle = class_8824.field_46597.decode(JsonOps.INSTANCE, AutoHost.config.dialogTitle).getOrThrow().getFirst();
        } catch (Exception e) {
            AutoHost.dialogTitle = class_2561.method_43470("The server's resource pack is still generating");
        }

        try {
            AutoHost.dialogDefaultBody = class_8824.field_46597.decode(JsonOps.INSTANCE, AutoHost.config.dialogDefaultBody).getOrThrow().getFirst();
        } catch (Exception e) {
            AutoHost.dialogDefaultBody = class_2561.method_43470("Waiting...");
        }

        try {
            AutoHost.dialogHeader = class_8824.field_46597.decode(JsonOps.INSTANCE, AutoHost.config.dialogHeader).getOrThrow().getFirst();
        } catch (Exception e) {
            AutoHost.dialogHeader = class_2561.method_43470("This server requires a resource pack, which hasn't finished generating yet...\nIt might take a moment for it to finish!");
        }


        var type = TYPES.get(class_2960.method_12829(config.type));


        if (type == null) {
            return;
        }

        provider = type.get();


        if (config.providerSettings != null) {
            provider.loadSettings(config.providerSettings);
        }

        config.providerSettings = provider.saveSettings();

        GLOBAL_RESOURCE_PACKS.clear();
        for (var x : config.externalResourcePacks) {
            if (x.url != null) {
                GLOBAL_RESOURCE_PACKS.add(ResourcePackDataProvider.createProperties(x.id, x.url, x.hash));
            }
        }

        CommonImpl.saveConfig("auto-host", config);

        provider.serverStarted(server);
    }

    public static void end(MinecraftServer server) {
        provider.serverStopped(server);
    }

    @Nullable
    public static Path getPath(String path) {
        var plus = path.indexOf('+');
        if (plus != -1) {
            path = path.substring(0, plus);
        }

        if (path.equals(DEFAULT_PATH)) {
            var mainPath = PolymerResourcePackUtils.getMainPath();
            if (PolymerResourcePackMod.useMainPath) {
                return mainPath;
            }

            return mainPath.resolveSibling(mainPath.getFileName().toString() + "_server.zip");
        }

        return FILES.get(path);
    }

    @Override
    public void onInitialize() {
        CommonImpl.registerConfig("auto-host", AutoHostConfig.class);

        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "automatic"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "auto"), NettyProvider::new);

        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "netty"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "same_port"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "http_server"), StandaloneWebServerProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "standalone"), StandaloneWebServerProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "external"), ExternalProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "empty"), EmptyProvider::new);

        CommonImplUtils.registerCommands((c) -> c.then(method_9247("generate-pack")
                        .requires(CommonImplUtils.permission("command.generate", 3))
                        .then(method_9247("reload").executes((ctx -> {
                            return PolymerResourcePackMod.generateResources(ctx, () -> {
                                if (!provider.isReady()) {
                                    ctx.getSource().method_45068(class_2561.method_43470("[Polymer] AutoHost module isn't configured/loaded correctly so resource pack won't be synced!"));
                                    return;
                                }
                                for (var player : ctx.getSource().method_9211().method_3760().method_14571()) {
                                    for (var x : provider.getProperties(((CommonNetworkHandlerExt) player.field_13987).polymerCommon$getConnection())) {
                                        player.field_13987.method_14364(new class_2720(x.comp_2156(), x.comp_784(), x.comp_785(), AutoHost.config.require || PolymerResourcePackUtils.isRequired(), Optional.ofNullable(AutoHost.message)));
                                    }
                                }
                            });
                        })))
                )
        );

        CommonImplUtils.registerDevCommands((c) -> {
            c.then(method_9247("reload_resourcepack").executes(context -> {
                if (provider.isReady()) {
                    for (var x : provider.getProperties(((CommonNetworkHandlerExt) context.getSource().method_9207().field_13987).polymerCommon$getConnection())) {
                        context.getSource().method_9207().field_13987.method_14364(new class_2720(x.comp_2156(), x.comp_784(), x.comp_785(), AutoHost.config.require || PolymerResourcePackUtils.isRequired(), Optional.ofNullable(AutoHost.message)));
                    }
                }
                return 0;
            }));

            c.then(method_9247("force_ready").then(method_9244("value", BoolArgumentType.bool()).executes((ctx) -> {
                if (provider instanceof AbstractProvider abs) {
                    abs.isPackReady = BoolArgumentType.getBool(ctx, "value");
                }
                return 0;
            })));
        });
    }
}
