/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import eu.pb4.polymer.autohost.api.AutoHostUtils;
import eu.pb4.polymer.autohost.api.ResourcePackDataProvider;
import eu.pb4.polymer.autohost.impl.AutoHostConfig;
import eu.pb4.polymer.autohost.impl.providers.AbstractProvider;
import eu.pb4.polymer.autohost.impl.providers.EmptyProvider;
import eu.pb4.polymer.autohost.impl.providers.ExternalProvider;
import eu.pb4.polymer.autohost.impl.providers.NettyProvider;
import eu.pb4.polymer.autohost.impl.providers.StandaloneWebServerProvider;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8824;
import net.minecraft.server.MinecraftServer;

public class AutoHost
implements ModInitializer {
    public static final Map<class_2960, Supplier<ResourcePackDataProvider>> TYPES = new HashMap<class_2960, Supplier<ResourcePackDataProvider>>();
    public static final List<MinecraftServer.class_7460> GLOBAL_RESOURCE_PACKS = new ArrayList<MinecraftServer.class_7460>();
    public static final Map<String, Path> FILES = new HashMap<String, Path>();
    public static AutoHostConfig config = new AutoHostConfig();
    public static class_2561 message = class_2561.method_43473();
    public static class_2561 disconnectMessage = class_2561.method_43473();
    public static class_2561 dialogTitle = class_2561.method_43473();
    public static class_2561 dialogDefaultBody = class_2561.method_43473();
    public static class_2561 dialogHeader = class_2561.method_43473();
    public static ResourcePackDataProvider provider = EmptyProvider.INSTANCE;
    public static final String DEFAULT_PATH = AutoHostUtils.getPathFromId(AutoHostUtils.DEFAULT_PACK_ID);
    public static boolean generateWhenDisabled = false;

    public static void init(MinecraftServer server) {
        AutoHostConfig config;
        AutoHost.config = config = (AutoHostConfig)CommonImpl.loadConfig((String)"auto-host", AutoHostConfig.class);
        if (!config.enabled) {
            if (generateWhenDisabled) {
                EmptyProvider.INSTANCE.serverStarted(server);
            }
            return;
        }
        try {
            message = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)AutoHost.config.message).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            message = null;
        }
        try {
            disconnectMessage = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)AutoHost.config.disconnectMessage).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            disconnectMessage = class_2561.method_43470((String)"This server requires resource pack enabled to play!");
        }
        try {
            dialogTitle = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)AutoHost.config.dialogTitle).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            dialogTitle = class_2561.method_43470((String)"The server's resource pack is still generating");
        }
        try {
            dialogDefaultBody = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)AutoHost.config.dialogDefaultBody).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            dialogDefaultBody = class_2561.method_43470((String)"Waiting...");
        }
        try {
            dialogHeader = (class_2561)((Pair)class_8824.field_46597.decode((DynamicOps)JsonOps.INSTANCE, (Object)AutoHost.config.dialogHeader).getOrThrow()).getFirst();
        }
        catch (Exception e) {
            dialogHeader = class_2561.method_43470((String)"This server requires a resource pack, which hasn't finished generating yet...\nIt might take a moment for it to finish!");
        }
        Supplier<ResourcePackDataProvider> type = TYPES.get(class_2960.method_12829((String)config.type));
        if (type == null) {
            return;
        }
        provider = type.get();
        if (config.providerSettings != null) {
            provider.loadSettings(config.providerSettings);
        }
        config.providerSettings = provider.saveSettings();
        GLOBAL_RESOURCE_PACKS.clear();
        for (AutoHostConfig.ExternalResourcePack x : config.externalResourcePacks) {
            if (x.url == null) continue;
            GLOBAL_RESOURCE_PACKS.add(ResourcePackDataProvider.createProperties(x.id, x.url, x.hash));
        }
        CommonImpl.saveConfig((String)"auto-host", (Object)config);
        provider.serverStarted(server);
    }

    public static void end(MinecraftServer server) {
        provider.serverStopped(server);
    }

    public static Path getPath(String path) {
        int plus = path.indexOf(43);
        if (plus != -1) {
            path = path.substring(0, plus);
        }
        if (path.equals(DEFAULT_PATH)) {
            Path mainPath = PolymerResourcePackUtils.getMainPath();
            if (PolymerResourcePackMod.useMainPath) {
                return mainPath;
            }
            return mainPath.resolveSibling(mainPath.getFileName().toString() + "_server.zip");
        }
        return FILES.get(path);
    }

    public void onInitialize() {
        CommonImpl.registerConfig((String)"auto-host", AutoHostConfig.class);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"automatic"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"auto"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"netty"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"same_port"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"http_server"), StandaloneWebServerProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"standalone"), StandaloneWebServerProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"external"), ExternalProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655((String)"polymer", (String)"empty"), EmptyProvider::new);
        CommonImplUtils.registerCommands(c -> c.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"generate-pack").requires(CommonImplUtils.permission((String)"command.generate", (int)3))).then(class_2170.method_9247((String)"reload").executes(ctx -> PolymerResourcePackMod.generateResources((CommandContext)ctx, () -> {
            if (!provider.isReady()) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"[Polymer] AutoHost module isn't configured/loaded correctly so resource pack won't be synced!"));
                return;
            }
            for (class_3222 player : ((class_2168)ctx.getSource()).method_9211().method_3760().method_14571()) {
                for (MinecraftServer.class_7460 x : provider.getProperties(((CommonNetworkHandlerExt)player.field_13987).polymerCommon$getConnection())) {
                    player.field_13987.method_14364((class_2596)new class_2720(x.comp_2156(), x.comp_784(), x.comp_785(), AutoHost.config.require || PolymerResourcePackUtils.isRequired(), Optional.ofNullable(message)));
                }
            }
        })))));
        CommonImplUtils.registerDevCommands(c -> {
            c.then(class_2170.method_9247((String)"reload_resourcepack").executes(context -> {
                if (provider.isReady()) {
                    for (MinecraftServer.class_7460 x : provider.getProperties(((CommonNetworkHandlerExt)((class_2168)context.getSource()).method_9207().field_13987).polymerCommon$getConnection())) {
                        ((class_2168)context.getSource()).method_9207().field_13987.method_14364((class_2596)new class_2720(x.comp_2156(), x.comp_784(), x.comp_785(), AutoHost.config.require || PolymerResourcePackUtils.isRequired(), Optional.ofNullable(message)));
                    }
                }
                return 0;
            }));
            c.then(class_2170.method_9247((String)"force_ready").then(class_2170.method_9244((String)"value", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
                ResourcePackDataProvider patt0$temp = provider;
                if (patt0$temp instanceof AbstractProvider) {
                    AbstractProvider abs = (AbstractProvider)patt0$temp;
                    abs.isPackReady = BoolArgumentType.getBool((CommandContext)ctx, (String)"value");
                }
                return 0;
            })));
        });
    }
}

