/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl.providers;

import com.google.common.hash.Hashing;
import eu.pb4.polymer.autohost.api.AutoHostUtils;
import eu.pb4.polymer.autohost.api.ResourcePackDataProvider;
import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public abstract class AbstractProvider
implements ResourcePackDataProvider {
    public long size = 0L;
    public String hash = "";
    public long lastUpdate = 0L;
    public boolean enabled;
    public boolean isPackReady = false;
    private Consumer<ResourcePackBuilder> eventA;
    private Runnable eventB;

    @Override
    public void serverStarted(MinecraftServer minecraftServer) {
        this.enabled = true;
        this.isPackReady = false;
        this.eventA = (Consumer)PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.registerRet(x -> {
            this.isPackReady = false;
        });
        this.eventB = (Runnable)PolymerResourcePackUtils.RESOURCE_PACK_FINISHED_EVENT.registerRet(() -> {
            this.updateHash();
            this.isPackReady = true;
        });
        try {
            PolymerResourcePackMod.generateAndCall((MinecraftServer)minecraftServer, (boolean)true, arg_0 -> ((MinecraftServer)minecraftServer).method_43496(arg_0), () -> {});
        }
        catch (Throwable e) {
            CommonImpl.LOGGER.warn("Failed to generate the resource pack!", e);
        }
    }

    @Override
    public void serverStopped(MinecraftServer server) {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.unregister(this.eventA);
        PolymerResourcePackUtils.RESOURCE_PACK_FINISHED_EVENT.unregister((Object)this.eventB);
    }

    protected boolean updateHash() {
        try {
            if (Files.exists(PolymerResourcePackUtils.getMainPath(), new LinkOption[0])) {
                this.hash = com.google.common.io.Files.asByteSource((File)PolymerResourcePackUtils.getMainPath().toFile()).hash(Hashing.sha1()).toString();
                this.size = Files.size(PolymerResourcePackUtils.getMainPath());
                this.lastUpdate = Files.getLastModifiedTime(PolymerResourcePackUtils.getMainPath(), new LinkOption[0]).toMillis();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hash = "";
        this.size = 0L;
        return false;
    }

    @Override
    public final Collection<MinecraftServer.class_7460> getProperties(class_2535 connection) {
        ArrayList<MinecraftServer.class_7460> list = new ArrayList<MinecraftServer.class_7460>();
        PacketContext.NotNull context = PacketContext.create((class_2535)connection);
        list.add(ResourcePackDataProvider.createProperties(PolymerResourcePackUtils.getMainUuid(), this.getMainFilePath((PacketContext)context), this.hash));
        AutoHostUtils.SEND_RESOURCE_PACK_COLLECTOR.invoke(x -> x.collectSendResourcePacks(this, (PacketContext)context, list::add));
        return list;
    }

    @Override
    public String getFilePath(PacketContext context, class_2960 identifier, @Nullable String hash) {
        if (!AutoHost.config.includeHashInName) {
            return this.getFilePath(context, identifier);
        }
        return this.getAddress(context.getClientConnection(), AutoHostUtils.getPathFromId(identifier) + "+" + hash + ".zip");
    }

    @Override
    public String getFilePath(PacketContext context, class_2960 identifier) {
        return this.getAddress(context.getClientConnection(), AutoHostUtils.getPathFromId(identifier) + "+pack.zip");
    }

    @Override
    public String getMainFilePath(PacketContext context) {
        return this.getFilePath(context, AutoHostUtils.DEFAULT_PACK_ID, this.hash);
    }

    protected abstract String getAddress(class_2535 var1, String var2);

    @Override
    public boolean isReady() {
        return this.isPackReady;
    }
}

