/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl.netty;

import eu.pb4.polymer.autohost.impl.netty.CustomHttpServerHandler;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.stream.ChunkedWriteHandler;
import net.minecraft.class_10550;
import org.jetbrains.annotations.NotNull;

public class ProtocolSwitcher
extends ChannelInboundHandlerAdapter {
    public static final String ID = "polymer:autohost/protocol_switcher";

    public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) throws Exception {
        Object object = class_10550.method_65939((Object)msg);
        if (!(object instanceof ByteBuf)) {
            return;
        }
        ByteBuf buf = (ByteBuf)object;
        int i = buf.readerIndex();
        if (buf.readableBytes() > 2 && ProtocolSwitcher.isHttp(buf.getByte(i), buf.getByte(i + 1))) {
            StringBuilder val = new StringBuilder();
            boolean store = false;
            int space = 0;
            for (int y = 0; y < buf.readableBytes(); ++y) {
                char character = (char)buf.getByte(i + y);
                if (character == ' ') {
                    if (space != 0) break;
                    store = true;
                    ++space;
                    continue;
                }
                if (!store) continue;
                val.append(character);
            }
            if (val.toString().startsWith("/eu.pb4.polymer.autohost/")) {
                ChannelPipeline p = ctx.channel().pipeline();
                while (p.last() != null) {
                    p.removeLast();
                }
                p.addLast(new ChannelHandler[]{new HttpServerCodec()});
                p.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
                p.addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                p.addLast(new ChannelHandler[]{new CustomHttpServerHandler()});
                ctx.pipeline().fireChannelRead(msg);
                return;
            }
        }
        ctx.channel().pipeline().remove(ID);
        buf.readerIndex(i);
        ctx.fireChannelRead(msg);
    }

    private static boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

