/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.api;

import com.google.gson.JsonElement;
import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2535;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public interface ResourcePackDataProvider {
    public boolean isReady();

    public JsonElement saveSettings();

    public void loadSettings(JsonElement var1);

    public void serverStarted(MinecraftServer var1);

    public void serverStopped(MinecraftServer var1);

    public static ResourcePackDataProvider getActive() {
        return AutoHost.provider;
    }

    public static <T> void register(class_2960 identifier, Supplier<ResourcePackDataProvider> providerCreator) {
        AutoHost.TYPES.put(identifier, providerCreator);
    }

    public Collection<MinecraftServer.class_7460> getProperties(class_2535 var1);

    public String getMainFilePath(PacketContext var1);

    public String getFilePath(PacketContext var1, class_2960 var2);

    default public String getFilePath(PacketContext context, class_2960 identifier, @Nullable String hash) {
        return this.getFilePath(context, identifier);
    }

    default public MinecraftServer.class_7460 createProperties(PacketContext context, class_2960 address) {
        return this.createProperties(context, null, address, null);
    }

    default public MinecraftServer.class_7460 createProperties(PacketContext context, class_2960 address, @Nullable String hash) {
        return this.createProperties(context, null, address, hash);
    }

    default public MinecraftServer.class_7460 createProperties(PacketContext context, @Nullable UUID uuid, class_2960 address, @Nullable String hash) {
        return ResourcePackDataProvider.createProperties(uuid, this.getFilePath(context, address), hash);
    }

    public static MinecraftServer.class_7460 createProperties(String address) {
        return ResourcePackDataProvider.createProperties(null, address, null);
    }

    public static MinecraftServer.class_7460 createProperties(String address, @Nullable String hash) {
        return ResourcePackDataProvider.createProperties(null, address, hash);
    }

    public static MinecraftServer.class_7460 createProperties(@Nullable UUID uuid, String address, @Nullable String hash) {
        return new MinecraftServer.class_7460(uuid != null ? uuid : UUID.nameUUIDFromBytes(address.getBytes(StandardCharsets.UTF_8)), address, hash != null ? hash : "", AutoHost.config.require || AutoHost.config.modOverride && PolymerResourcePackUtils.isRequired(), AutoHost.message);
    }
}

