/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl.netty;

import eu.pb4.polymer.autohost.impl.AutoHost;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

public class CustomHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private FullHttpRequest request;

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        ChannelFuture lastContentFuture;
        SeekableByteChannel raf;
        this.request = request;
        if (!request.decoderResult().isSuccess() || request.uri().length() < "/eu.pb4.polymer.autohost/".length()) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (!HttpMethod.GET.equals((Object)request.method())) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        String path = request.uri().substring("/eu.pb4.polymer.autohost/".length());
        Path file = AutoHost.getPath(path);
        if (file == null || !Files.isRegularFile(file, new LinkOption[0])) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        try {
            raf = Files.newByteChannel(file, StandardOpenOption.READ);
        }
        catch (Throwable ignore) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.size();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        response.headers().add("Server", (Object)"polymer-autohost");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/zip");
        response.headers().set("Cache-Control", (Object)("public, max-age=" + AutoHost.config.cacheControlAge));
        if (!keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        if (ctx.pipeline().get(SslHandler.class) == null) {
            ChannelFuture sendFileFuture = ctx.write((Object)new ChunkedNioStream((ReadableByteChannel)raf, 8192), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            ChannelFuture sendFileFuture;
            lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedNioStream((ReadableByteChannel)raf, 8192)), (ChannelPromise)ctx.newProgressivePromise());
        }
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        lastContentFuture.addListener(f -> raf.close());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + String.valueOf(status) + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
    }

    private void sendAndCleanupConnection(ChannelHandlerContext ctx, FullHttpResponse response) {
        FullHttpRequest request = this.request;
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        if (!keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ChannelFuture flushPromise = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            flushPromise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

