/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl;

import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_11406;
import net.minecraft.class_11407;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11428;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_11524;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.class_9053;
import net.minecraft.server.MinecraftServer;

public class AutoHostTask
implements class_8605 {
    public static final class_8605.class_8606 KEY = new class_8605.class_8606("polymer:autohost/send_packs");
    public static final class_2960 DISCONNECT = class_2960.method_60654((String)"polymer:autohost/disconnect");
    private final Collection<MinecraftServer.class_7460> packs;
    private final Set<UUID> requiredPacks = new HashSet<UUID>();
    private final Set<UUID> waitingFor = new HashSet<UUID>();
    private final Supplier<Collection<MinecraftServer.class_7460>> delayed;
    private final BooleanSupplier isReady;
    private final Map<UUID, MinecraftServer.class_7460> map = new HashMap<UUID, MinecraftServer.class_7460>();
    private boolean hasDelayed;
    private int tick = 0;

    public AutoHostTask(Collection<MinecraftServer.class_7460> properties, boolean hasDelayed, Supplier<Collection<MinecraftServer.class_7460>> delayed, BooleanSupplier isReady) {
        this.packs = properties;
        for (MinecraftServer.class_7460 pack : this.packs) {
            if (pack.comp_786()) {
                this.requiredPacks.add(pack.comp_2156());
            }
            this.waitingFor.add(pack.comp_2156());
        }
        this.hasDelayed = hasDelayed;
        this.delayed = delayed;
        this.isReady = isReady;
    }

    public void method_52376(Consumer<class_2596<?>> sender) {
        if (AutoHost.config.clearResourcePacks) {
            sender.accept((class_2596<?>)new class_9053(Optional.empty()));
        }
        if (this.hasDelayed) {
            this.sendDialog(sender);
            return;
        }
        for (MinecraftServer.class_7460 pack : this.packs) {
            this.map.put(pack.comp_2156(), pack);
            sender.accept((class_2596<?>)new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
        }
    }

    private void sendDialog(Consumer<class_2596<?>> sender) {
        if (!AutoHost.config.dialog) {
            return;
        }
        ArrayList<class_11435> list = new ArrayList<class_11435>(4);
        list.add(new class_11435(AutoHost.dialogHeader, 300));
        if (AutoHost.config.dialogShowDots) {
            StringBuilder sb = new StringBuilder();
            int index = (this.tick - 1) / 2 % 10;
            if ((this.tick - 1) / 2 % 20 >= 10) {
                index = 9 - index;
            }
            for (int i = 1; i < index; ++i) {
                sb.append('_');
            }
            if (index > 0) {
                sb.append('o');
            }
            sb.append('O');
            if (sb.length() < 10) {
                sb.append('o');
                while (sb.length() < 10) {
                    sb.append('_');
                }
            }
            list.add(new class_11435((class_2561)class_2561.method_43470((String)sb.toString()).method_27692(class_124.field_1080), 200));
        }
        list.add(new class_11435((class_2561)(PolymerResourcePackMod.STATUS.isEmpty() || !AutoHost.config.dialogShowStatus ? AutoHost.dialogDefaultBody : class_2561.method_43470((String)String.join((CharSequence)"\n", PolymerResourcePackMod.STATUS.subList(Math.max(PolymerResourcePackMod.STATUS.size() - 6, 0), PolymerResourcePackMod.STATUS.size())))), 300));
        sender.accept((class_2596<?>)new class_11407(class_6880.method_40223((Object)new class_11428(new class_11417(AutoHost.dialogTitle, Optional.empty(), false, false, class_11520.field_60962, list, List.of()), new class_11519(new class_11416((class_2561)class_2561.method_43471((String)"menu.disconnect"), 150), Optional.of(new class_11524(DISCONNECT, Optional.empty())))))));
    }

    public void tick(Consumer<class_2596<?>> sender) {
        if (this.hasDelayed && this.isReady.getAsBoolean()) {
            if (AutoHost.config.dialog) {
                sender.accept((class_2596<?>)class_11406.field_60602);
            }
            Collection<MinecraftServer.class_7460> delayed = this.delayed.get();
            for (MinecraftServer.class_7460 pack : delayed) {
                this.map.put(pack.comp_2156(), pack);
                if (pack.comp_786()) {
                    this.requiredPacks.add(pack.comp_2156());
                }
                this.waitingFor.add(pack.comp_2156());
            }
            for (MinecraftServer.class_7460 pack : this.packs) {
                sender.accept((class_2596<?>)new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
            }
            for (MinecraftServer.class_7460 pack : delayed) {
                sender.accept((class_2596<?>)new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
            }
            this.hasDelayed = false;
        } else if (this.hasDelayed && ++this.tick % 2 == 0) {
            this.sendDialog(sender);
        }
    }

    public class_8605.class_8606 method_52375() {
        return KEY;
    }

    public boolean onStatus(class_8610 handler, UUID id, class_2856.class_2857 status) {
        switch (status) {
            case field_13018: 
            case field_47668: 
            case field_13015: 
            case field_47667: {
                if (!this.requiredPacks.contains(id)) break;
                class_2561 text = AutoHost.disconnectMessage;
                if (AutoHost.config.informativeDisconnect) {
                    MinecraftServer.class_7460 pack = this.map.get(id);
                    String packInfo = pack == null ? "<Invalid pack?>" : (pack.comp_785().isEmpty() ? "<NO HASH>" : pack.comp_785()) + "\n" + pack.comp_784();
                    String main = PolymerResourcePackUtils.getMainUuid().equals(id) ? " (Main)" : "";
                    text = class_2561.method_43473().method_10852(text).method_27693("\n\n").method_10852((class_2561)class_2561.method_43470((String)(status.name() + " > " + String.valueOf(id) + main + "\n" + packInfo)).method_27692(class_124.field_1080));
                }
                handler.method_52396(text);
            }
        }
        if (status.method_55627()) {
            this.waitingFor.remove(id);
        }
        return this.waitingFor.isEmpty() && !this.hasDelayed;
    }
}

