package eu.pb4.polymer.autohost.impl;

import com.mojang.brigadier.arguments.BoolArgumentType;
import eu.pb4.polymer.autohost.api.ResourcePackDataProvider;
import eu.pb4.polymer.autohost.impl.AutoHostConfig.ExternalResourcePack;
import eu.pb4.polymer.autohost.impl.providers.AbstractProvider;
import eu.pb4.polymer.autohost.impl.providers.EmptyProvider;
import eu.pb4.polymer.autohost.impl.providers.NettyProvider;
import eu.pb4.polymer.autohost.impl.providers.StandaloneWebServerProvider;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2561;
import net.minecraft.class_2720;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MinecraftServer.class_7460;
import java.io.File;
import java.nio.file.Path;
import java.util.*;
import java.util.function.Consumer;
import java.util.function.Supplier;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class AutoHost implements ModInitializer {
    public static final Map<class_2960, Supplier<ResourcePackDataProvider>> TYPES = new HashMap<>();
    public static final List<MinecraftServer.class_7460> GLOBAL_RESOURCE_PACKS = new ArrayList<>();
    public static AutoHostConfig config = new AutoHostConfig();
    public static class_2561 message = class_2561.method_43473();
    public static class_2561 disconnectMessage = class_2561.method_43473();
    public static ResourcePackDataProvider provider = EmptyProvider.INSTANCE;

    public static void init(MinecraftServer server) {
        var config = CommonImpl.loadConfig("auto-host", AutoHostConfig.class);
        AutoHost.config = config;

        if (!config.enabled) {
            return;
        }

        try {
            AutoHost.message = class_2561.class_2562.method_10872(AutoHost.config.message, server.method_30611());
        } catch (Exception e) {
            AutoHost.message = null;
        }

        try {
            AutoHost.disconnectMessage = class_2561.class_2562.method_10872(AutoHost.config.disconnectMessage, server.method_30611());
        } catch (Exception e) {
            AutoHost.disconnectMessage = class_2561.method_43470("This server requires resource pack enabled to play!");
        }

        var type = TYPES.get(class_2960.method_12829(config.type));


        if (type == null) {
            return;
        }

        provider = type.get();


        if (config.providerSettings != null) {
            provider.loadSettings(config.providerSettings);
        }

        config.providerSettings = provider.saveSettings();

        GLOBAL_RESOURCE_PACKS.clear();
        for (var x : config.externalResourcePacks) {
            if (x.url != null) {
                GLOBAL_RESOURCE_PACKS.add(ResourcePackDataProvider.createProperties(x.id, x.url, x.hash));
            }
        }


        CommonImpl.saveConfig("auto-host", config);

        provider.serverStarted(server);
    }

    public static void end(MinecraftServer server) {
        provider.serverStopped(server);
    }

    @Deprecated(forRemoval = true)
    public static void generateAndCall(MinecraftServer server, Consumer<class_2561> messageConsumer, Runnable runnable) {
        PolymerResourcePackMod.generateAndCall(server, true, messageConsumer, runnable);
    }

    public static File getFile(String path) {
        var x = getPath(path);
        return x != null ? x.toFile() : null;
    }

    public static Path getPath(String path) {
        if (path.equals("main.zip")) {
            return PolymerResourcePackUtils.getMainPath();
        }

        return null;
    }

    @Override
    public void onInitialize() {
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "automatic"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "auto"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "netty"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "same_port"), NettyProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "http_server"), StandaloneWebServerProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "standalone"), StandaloneWebServerProvider::new);
        ResourcePackDataProvider.register(class_2960.method_60655("polymer", "empty"), EmptyProvider::new);

        CommonImplUtils.registerCommands((c) -> c.then(method_9247("generate-pack")
                        .requires(CommonImplUtils.permission("command.generate", 3))
                        .then(method_9247("reload").executes((ctx -> {
                            return PolymerResourcePackMod.generateResources(ctx, () -> {
                                if (!provider.isReady()) {
                                    ctx.getSource().method_45068(class_2561.method_43470("[Polymer] AutoHost module isn't configured/loaded correctly so resource pack won't be synced!"));
                                    return;
                                }
                                for (var player : ctx.getSource().method_9211().method_3760().method_14571()) {
                                    for (var x : provider.getProperties(((CommonNetworkHandlerExt) player.field_13987).polymerCommon$getConnection())) {
                                        player.field_13987.method_14364(new class_2720(x.comp_2156(), x.comp_784(), x.comp_785(), AutoHost.config.require || PolymerResourcePackUtils.isRequired(), Optional.ofNullable(AutoHost.message)));
                                    }
                                }
                            });
                        })))
                )
        );

        CommonImplUtils.registerDevCommands((c) -> {
            c.then(method_9247("reload_resourcepack").executes(context -> {
                if (provider.isReady()) {
                    for (var x : provider.getProperties(((CommonNetworkHandlerExt) context.getSource().method_9207().field_13987).polymerCommon$getConnection())) {
                        context.getSource().method_9207().field_13987.method_14364(new class_2720(x.comp_2156(), x.comp_784(), x.comp_785(), AutoHost.config.require || PolymerResourcePackUtils.isRequired(), Optional.ofNullable(AutoHost.message)));
                    }
                }
                return 0;
            }));

            c.then(method_9247("force_ready").then(method_9244("value", BoolArgumentType.bool()).executes((ctx) -> {
                if (provider instanceof AbstractProvider abs) {
                    abs.isPackReady = BoolArgumentType.getBool(ctx, "value");
                }
                return 0;
            })));
        });
    }
}
