package eu.pb4.polymer.autohost.impl;

import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MinecraftServer.class_7460;
import java.util.*;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AutoHostTask implements class_8605 {
    public static final class_8606 KEY = new class_8606("polymer:autohost/send_packs");
    private final Collection<MinecraftServer.class_7460> packs;

    private final Set<UUID> requiredPacks = new HashSet<>();
    private final Set<UUID> waitingFor = new HashSet<>();
    private final Supplier<Collection<MinecraftServer.class_7460>> delayed;
    private final BooleanSupplier isReady;
    private boolean hasDelayed;

    public AutoHostTask(Collection<MinecraftServer.class_7460> properties, boolean hasDelayed,
                        Supplier<Collection<MinecraftServer.class_7460>> delayed, BooleanSupplier isReady) {
        this.packs = properties;
        for (var pack : packs) {
            if (pack.comp_786()) {
                requiredPacks.add(pack.comp_2156());
            }
            waitingFor.add(pack.comp_2156());
        }
        this.hasDelayed = hasDelayed;
        this.delayed = delayed;
        this.isReady = isReady;
    }

    public void tick(Consumer<class_2596<?>> sender) {
        if (this.hasDelayed && this.isReady.getAsBoolean()) {
            var delayed = this.delayed.get();
            for (var pack : delayed) {
                if (pack.comp_786()) {
                    requiredPacks.add(pack.comp_2156());
                }
                waitingFor.add(pack.comp_2156());
            }
            for (var pack : delayed) {
                sender.accept(new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
            }
            this.hasDelayed = false;
        }
    }

    @Override
    public void method_52376(Consumer<class_2596<?>> sender) {
        for (var pack : packs) {
            sender.accept(new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
        }
    }

    @Override
    public class_8606 method_52375() {
        return KEY;
    }

    public boolean onStatus(class_8610 handler, UUID id, class_2856.class_2857 status) {
        switch (status) {
            case field_13018, field_47668, field_13015, field_47667 -> {
                if (this.requiredPacks.contains(id)) {
                    handler.method_52396(class_2561.method_43471("multiplayer.requiredTexturePrompt.disconnect"));
                }
            }
        }

        if (status.method_55627()) {
            this.waitingFor.remove(id);
        }

        return this.waitingFor.isEmpty() && !this.hasDelayed;
    }
}
