/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2720;
import net.minecraft.class_2856;
import net.minecraft.class_8605;
import net.minecraft.class_8610;
import net.minecraft.server.MinecraftServer;

public class AutoHostTask
implements class_8605 {
    public static final class_8605.class_8606 KEY = new class_8605.class_8606("polymer:autohost/send_packs");
    private final Collection<MinecraftServer.class_7460> packs;
    private final Set<UUID> requiredPacks = new HashSet<UUID>();
    private final Set<UUID> waitingFor = new HashSet<UUID>();
    private final Supplier<Collection<MinecraftServer.class_7460>> delayed;
    private final BooleanSupplier isReady;
    private boolean hasDelayed;

    public AutoHostTask(Collection<MinecraftServer.class_7460> properties, boolean hasDelayed, Supplier<Collection<MinecraftServer.class_7460>> delayed, BooleanSupplier isReady) {
        this.packs = properties;
        for (MinecraftServer.class_7460 pack : this.packs) {
            if (pack.comp_786()) {
                this.requiredPacks.add(pack.comp_2156());
            }
            this.waitingFor.add(pack.comp_2156());
        }
        this.hasDelayed = hasDelayed;
        this.delayed = delayed;
        this.isReady = isReady;
    }

    public void tick(Consumer<class_2596<?>> sender) {
        if (this.hasDelayed && this.isReady.getAsBoolean()) {
            Collection<MinecraftServer.class_7460> delayed = this.delayed.get();
            for (MinecraftServer.class_7460 pack : delayed) {
                if (pack.comp_786()) {
                    this.requiredPacks.add(pack.comp_2156());
                }
                this.waitingFor.add(pack.comp_2156());
            }
            for (MinecraftServer.class_7460 pack : delayed) {
                sender.accept((class_2596<?>)new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
            }
            this.hasDelayed = false;
        }
    }

    public void method_52376(Consumer<class_2596<?>> sender) {
        for (MinecraftServer.class_7460 pack : this.packs) {
            sender.accept((class_2596<?>)new class_2720(pack.comp_2156(), pack.comp_784(), pack.comp_785(), pack.comp_786(), Optional.ofNullable(pack.comp_787())));
        }
    }

    public class_8605.class_8606 method_52375() {
        return KEY;
    }

    public boolean onStatus(class_8610 handler, UUID id, class_2856.class_2857 status) {
        switch (status) {
            case field_13018: 
            case field_47668: 
            case field_13015: 
            case field_47667: {
                if (!this.requiredPacks.contains(id)) break;
                handler.method_52396((class_2561)class_2561.method_43471((String)"multiplayer.requiredTexturePrompt.disconnect"));
            }
        }
        if (status.method_55627()) {
            this.waitingFor.remove(id);
        }
        return this.waitingFor.isEmpty() && !this.hasDelayed;
    }
}

