/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl.netty;

import eu.pb4.polymer.autohost.api.ResourcePackDataProvider;
import eu.pb4.polymer.autohost.impl.AutoHost;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;

public class CustomHttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private FullHttpRequest request;

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        ChannelFuture lastContentFuture;
        RandomAccessFile raf;
        this.request = request;
        if (!request.decoderResult().isSuccess() || request.uri().length() < "/eu.pb4.polymer.autohost/".length()) {
            this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
            return;
        }
        if (!HttpMethod.GET.equals((Object)request.method())) {
            this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
            return;
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        String path = request.uri().substring("/eu.pb4.polymer.autohost/".length());
        File file = AutoHost.getFile(path);
        if (file == null || !file.isFile() || !ResourcePackDataProvider.getActive().isReady()) {
            this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
            return;
        }
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignore) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        long fileLength = raf.length();
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/zip");
        if (!keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ctx.write((Object)response);
        if (ctx.pipeline().get(SslHandler.class) == null) {
            ChannelFuture sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            ChannelFuture sendFileFuture;
            lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
        }
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        if (ctx.channel().isActive()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + String.valueOf(status) + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
    }

    private void sendAndCleanupConnection(ChannelHandlerContext ctx, FullHttpResponse response) {
        FullHttpRequest request = this.request;
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        if (!keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ChannelFuture flushPromise = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            flushPromise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

