/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl.providers;

import com.google.common.hash.Hashing;
import eu.pb4.polymer.autohost.api.ResourcePackDataProvider;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.api.ResourcePackBuilder;
import eu.pb4.polymer.resourcepack.impl.PolymerResourcePackMod;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2535;
import net.minecraft.server.MinecraftServer;

public abstract class AbstractProvider
implements ResourcePackDataProvider {
    public long size = 0L;
    public String hash = "";
    public long lastUpdate = 0L;
    public boolean enabled;
    public boolean isPackReady = false;
    private Consumer<ResourcePackBuilder> eventA;
    private Runnable eventB;

    @Override
    public void serverStarted(MinecraftServer minecraftServer) {
        this.enabled = true;
        this.isPackReady = false;
        this.eventA = (Consumer)PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.registerRet(x -> {
            this.isPackReady = false;
        });
        this.eventB = (Runnable)PolymerResourcePackUtils.RESOURCE_PACK_FINISHED_EVENT.registerRet(() -> {
            this.updateHash();
            this.isPackReady = true;
        });
        PolymerResourcePackMod.generateAndCall((MinecraftServer)minecraftServer, (boolean)true, arg_0 -> ((MinecraftServer)minecraftServer).method_43496(arg_0), () -> {});
    }

    @Override
    public void serverStopped(MinecraftServer server) {
        PolymerResourcePackUtils.RESOURCE_PACK_CREATION_EVENT.unregister(this.eventA);
        PolymerResourcePackUtils.RESOURCE_PACK_FINISHED_EVENT.unregister((Object)this.eventB);
    }

    protected boolean updateHash() {
        try {
            if (Files.exists(PolymerResourcePackUtils.getMainPath(), new LinkOption[0])) {
                this.hash = com.google.common.io.Files.asByteSource((File)PolymerResourcePackUtils.getMainPath().toFile()).hash(Hashing.sha1()).toString();
                this.size = Files.size(PolymerResourcePackUtils.getMainPath());
                this.lastUpdate = Files.getLastModifiedTime(PolymerResourcePackUtils.getMainPath(), new LinkOption[0]).toMillis();
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.hash = "";
        this.size = 0L;
        return false;
    }

    @Override
    public Collection<MinecraftServer.class_7460> getProperties(class_2535 connection) {
        return List.of(ResourcePackDataProvider.createProperties(PolymerResourcePackUtils.getMainUuid(), this.getAddress(connection), this.hash));
    }

    protected abstract String getAddress(class_2535 var1);

    @Override
    public boolean isReady() {
        return this.isPackReady;
    }
}

