/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.autohost.impl.providers;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import eu.pb4.polymer.autohost.impl.AutoHost;
import eu.pb4.polymer.autohost.impl.providers.AbstractProvider;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.concurrent.Executors;
import net.minecraft.class_2535;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class StandaloneWebServerProvider
extends AbstractProvider {
    private Config config;
    private HttpServer server;
    public String baseAddress = "";
    public String fullAddress = "";

    @Override
    @Nullable
    public void serverStarted(MinecraftServer minecraftServer) {
        try {
            InetSocketAddress address = StandaloneWebServerProvider.createBindAddress(minecraftServer, this.config);
            this.server = HttpServer.create(address, 0);
            this.server.createContext("/", this::handle);
            this.server.setExecutor(Executors.newFixedThreadPool(2));
            this.server.start();
            this.baseAddress = this.config.externalAddress;
            if (!this.baseAddress.endsWith("/")) {
                this.baseAddress = this.baseAddress + "/";
            }
            super.serverStarted(minecraftServer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Nullable
    public void serverStopped(MinecraftServer minecraftServer) {
        if (this.server != null) {
            this.server.stop(0);
        }
    }

    @Override
    protected boolean updateHash() {
        if (super.updateHash()) {
            this.fullAddress = this.baseAddress + "main.zip";
            return true;
        }
        return false;
    }

    @Override
    protected String getAddress(class_2535 connection) {
        return this.fullAddress;
    }

    private static InetSocketAddress createBindAddress(MinecraftServer server, Config config) {
        String serverIp = server.method_3819();
        if (!Strings.isNullOrEmpty((String)serverIp)) {
            return new InetSocketAddress(serverIp, config.port);
        }
        return new InetSocketAddress(config.port);
    }

    public void handle(HttpExchange exchange) throws IOException {
        Path path;
        if ("GET".equals(exchange.getRequestMethod()) && Files.exists(path = AutoHost.getPath(exchange.getRequestURI().getPath().substring(1)), new LinkOption[0])) {
            long updateTime = Files.getLastModifiedTime(path, new LinkOption[0]).toMillis();
            if (updateTime > this.lastUpdate) {
                this.updateHash();
            }
            try (InputStream input = Files.newInputStream(PolymerResourcePackUtils.getMainPath(), new OpenOption[0]);
                 OutputStream output = exchange.getResponseBody();){
                exchange.getResponseHeaders().add("Server", "polymer-autohost");
                exchange.getResponseHeaders().add("Content-Type", "application/zip");
                exchange.sendResponseHeaders(200, this.size);
                input.transferTo(output);
                output.flush();
            }
        }
    }

    @Override
    public JsonElement saveSettings() {
        return this.config.toJson();
    }

    @Override
    public void loadSettings(JsonElement settings) {
        this.config = (Config)CommonImpl.GSON.fromJson(settings, Config.class);
        if (this.config == null) {
            this.config = new Config();
        }
    }

    public static class Config {
        public String _c1 = "Port used internally to run http server";
        public int port = 25567;
        public String _c2 = "Public address used for sending requests";
        @SerializedName(value="external_address")
        public String externalAddress = "http://localhost:25567/";

        public JsonElement toJson() {
            return CommonImpl.GSON.toJsonTree((Object)this);
        }
    }
}

