package eu.pb4.polymer.blocks.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CompatStatus;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import java.util.*;

import static net.minecraft.class_2170.method_9247;

public class PolymerBlocksInternal implements ModInitializer {
    public static Map<class_2680, PolymerBlockModel[]> modelMap = Collections.emptyMap();



    public static JsonArray createJsonElement(PolymerBlockModel[] models) {
        var array = new JsonArray();

        for (var model : models) {
            var modelObj = new JsonObject();

            modelObj.addProperty("model", model.model().toString());
            modelObj.addProperty("x", model.x());
            modelObj.addProperty("y", model.y());
            modelObj.addProperty("uvlock", model.uvLock());
            modelObj.addProperty("weight", model.weight());

            array.add(modelObj);
        }

        return array;
    }

    public static String generateStateName(class_2680 state) {
        var stringBuilder = new StringBuilder();

        var entries = new ArrayList<>(state.method_11656().entrySet());
        entries.sort(Map.Entry.comparingByKey(Comparator.comparing(class_2769::method_11899)));
        var iterator = entries.iterator();

        while (iterator.hasNext()) {
            var entry = iterator.next();
            stringBuilder.append((entry.getKey()).method_11899()).append("=").append(((class_2769) entry.getKey()).method_11901(entry.getValue()));

            if (iterator.hasNext()) {
                stringBuilder.append(",");
            }
        }

        return stringBuilder.toString();
    }

    @Override
    public void onInitialize() {
        CommonImplUtils.registerCommands(c -> c.then(method_9247("blocks_module_state_report")
                .requires(CommonImplUtils.permission("blocks_module_state_report", 3))
                .executes(ctx -> {
                    ctx.getSource().method_45068(class_2561.method_43470("States of blockstates provided by polymer-blocks module:"));
                    if (CompatStatus.POLYMC) {
                        ctx.getSource().method_45068(class_2561.method_43470("PolyMc is present! Values provided here won't reflect it's state here! Use /polymc command instead!").method_27692(class_124.field_1061));
                    }

                    for (var type : BlockModelType.values()) {
                        ctx.getSource().method_45068(class_2561.method_43470("- " + type + " -> " + PolymerBlockResourceUtils.getBlocksLeft(type) + " / " + DefaultModelData.USABLE_STATES.get(type).size()));
                    }

                    return 0;
                })));

        /*
        var text = new StringBuilder();

        for (var b : Registries.BLOCK) {
            var x = Registries.BLOCK.getId(b);
            if (x.getNamespace().equals("minecraft") && x.getPath().endsWith("_slab") && !x.getPath().contains("smooth_stone")) {
                var base = x.getPath().substring(0, x.getPath().length() - "_slab".length());
                var other = base + (Registries.BLOCK.containsId(x.withPath(base + "_planks")) ? "_planks" : "");

                text.append("new Pair<>(Blocks.")
                        .append(x.getPath().toUpperCase(Locale.ROOT))
                        .append(", Blocks.")
                        .append(other.toUpperCase(Locale.ROOT))
                        .append("),\n");
            }
        }

        System.out.println(text);
        */
    }
}
