package eu.pb4.polymer.blocks.mixin.polymc;

import eu.pb4.polymer.blocks.impl.BlockExtBlockMapper;
import io.github.theepicblock.polymc.api.PolyMap;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(PolyMap.class)
public interface PolyMapImplMixin {
    @Inject(method = "getClientState", at = @At("HEAD"), cancellable = true, require = 0)
    private void skipPolymerHandledBlocks(class_2680 serverBlock, class_3222 player, CallbackInfoReturnable<class_2680> cir) {
        if (BlockExtBlockMapper.INSTANCE.stateMap.containsKey(serverBlock)) {
            cir.setReturnValue(serverBlock);
        }
    }
}
