package eu.pb4.polymer.blocks.impl;

import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import io.github.theepicblock.polymc.api.PolyMcEntrypoint;
import io.github.theepicblock.polymc.api.PolyRegistry;
import io.github.theepicblock.polymc.api.resource.ModdedResources;
import io.github.theepicblock.polymc.api.resource.PolyMcResourcePack;
import io.github.theepicblock.polymc.api.resource.json.JBlockStateVariant;
import io.github.theepicblock.polymc.impl.misc.logging.SimpleLogger;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class PolyMcResourceEntrypoint implements PolyMcEntrypoint {
    @Override
    public void registerPolys(PolyRegistry registry) {
        for (var block : class_7923.field_41175) {
            if (PolymerSyncedObject.getSyncedObject(class_7923.field_41175, block) instanceof PolymerTexturedBlock) {
                registry.registerBlockPoly(block, new PolymerTextureBlockPoly());
            }
        }
    }

    @Override
    public void registerModSpecificResources(ModdedResources moddedResources, PolyMcResourcePack pack, SimpleLogger logger) {
        for (var entry : PolymerBlocksInternal.modelMap.entrySet()) {
            class_2960 clientBlockId = class_7923.field_41175.method_10221(entry.getKey().method_26204());
            var clientBlockState = pack.getOrDefaultBlockState(clientBlockId.method_12836(), clientBlockId.method_12832());

            var stateName = PolymerBlocksInternal.generateStateName(entry.getKey());
            var array = PolymerBlocksInternal.createJsonElement(entry.getValue());

            clientBlockState.setVariant(stateName, pack.getGson().fromJson(array, JBlockStateVariant[].class));
        }
    }
}
