package eu.pb4.polymer.blocks.api;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2960;

public record MultiPolymerBlockModel(List<PolymerBlockModel[]> models) {
    public static MultiPolymerBlockModel of() {
        return new MultiPolymerBlockModel(new ArrayList<>());
    }


    public MultiPolymerBlockModel with(PolymerBlockModel... models) {
        this.models.add(models);
        return this;
    }

    public MultiPolymerBlockModel with(class_2960 identifier) {
        this.models.add(new PolymerBlockModel[]{ PolymerBlockModel.of(identifier) });
        return this;
    }
}
