/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.blocks.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.MultiPolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.impl.BlockExtBlockMapper;
import eu.pb4.polymer.blocks.impl.DefaultModelData;
import eu.pb4.polymer.blocks.impl.PolymerBlocksInternal;
import eu.pb4.polymer.blocks.impl.VanillaBlockPropertiesPredicate;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3737;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class BlockResourceCreator {
    private static final PolymerBlockModel EMPTY = PolymerBlockModel.of(class_2960.method_60655((String)"polymer", (String)"block/empty"));
    private final Map<BlockModelType, List<class_2680>> states;
    private final Set<class_2248> hasRequested = Collections.newSetFromMap(new IdentityHashMap());
    final Map<class_2680, Either<PolymerBlockModel[], MultiPolymerBlockModel>> models;
    private final ResourcePackCreator creator;
    private final Runnable onRegister;
    private final BlockExtBlockMapper blockMapper;
    private final EnumMap<BlockModelType, class_2680> emptyBlocks = new EnumMap(BlockModelType.class);
    private boolean registered = false;
    private boolean registeredEmpty = false;

    public static BlockResourceCreator of(ResourcePackCreator creator) {
        if (CompatStatus.POLYMC) {
            PolymerImpl.LOGGER.warn("Polymer Blocks non-global module might not work correctly with PolyMC! Be warned!");
        }
        return new BlockResourceCreator(creator, new BlockExtBlockMapper(BlockMapper.createDefault()), () -> {});
    }

    BlockResourceCreator(ResourcePackCreator creator, BlockExtBlockMapper blockMapper, Runnable onRegister) {
        this.states = new EnumMap<BlockModelType, List<class_2680>>(BlockModelType.class);
        DefaultModelData.USABLE_STATES.forEach((key, value) -> this.states.put((BlockModelType)((Object)key), (List<class_2680>)new ReferenceArrayList((Collection)value)));
        this.models = new IdentityHashMap<class_2680, Either<PolymerBlockModel[], MultiPolymerBlockModel>>(DefaultModelData.MODELS);
        this.creator = creator;
        this.blockMapper = blockMapper;
        this.onRegister = onRegister;
    }

    public BlockMapper getBlockMapper() {
        return this.blockMapper;
    }

    private void registerEvent() {
        if (!this.registered) {
            this.creator.creationEvent.register(b -> {
                if (b instanceof DefaultRPBuilder) {
                    DefaultRPBuilder defaultRPBuilder = (DefaultRPBuilder)b;
                    defaultRPBuilder.buildEvent.register(c -> this.generateResources(defaultRPBuilder, (List<String>)c));
                }
            });
            this.onRegister.run();
            this.registered = true;
        }
    }

    @Nullable
    public class_2680 requestEmpty(BlockModelType type) {
        class_2680 x = this.emptyBlocks.get((Object)type);
        if (x != null) {
            return x;
        }
        Predicate<class_2680> predicate = null;
        if (type.name().contains("TRAPDOOR")) {
            predicate = b -> b.method_27852(class_2246.field_10453);
        } else if (type.name().contains("DOOR")) {
            predicate = b -> b.method_27852(class_2246.field_9973);
        } else if (type == BlockModelType.VINES_BLOCK) {
            predicate = b -> b.method_27852(class_2246.field_23078);
        }
        if (predicate != null) {
            x = this.requestBlockImpl(type, predicate, true, (Either<PolymerBlockModel[], MultiPolymerBlockModel>)Either.left((Object)new PolymerBlockModel[]{EMPTY}));
        }
        if (x == null) {
            x = this.requestBlockImpl(type, y -> true, true, (Either<PolymerBlockModel[], MultiPolymerBlockModel>)Either.left((Object)new PolymerBlockModel[]{EMPTY}));
        }
        if (x == null) {
            return null;
        }
        this.emptyBlocks.put(type, x);
        if (!this.registeredEmpty) {
            this.registeredEmpty = true;
            this.creator.addAssetSource("polymer-blocks");
        }
        return x;
    }

    @Nullable
    public class_2680 requestBlock(BlockModelType type, PolymerBlockModel ... model) {
        return this.requestBlock(type, (class_2680 x) -> true, model);
    }

    public class_2680 requestBlock(BlockModelType type, Predicate<class_2680> predicate, PolymerBlockModel ... model) {
        return this.requestBlockImpl(type, predicate, false, (Either<PolymerBlockModel[], MultiPolymerBlockModel>)Either.left((Object)model));
    }

    @Nullable
    public class_2680 requestBlock(BlockModelType type, MultiPolymerBlockModel model) {
        return this.requestBlock(type, (class_2680 x) -> true, model);
    }

    public class_2680 requestBlock(BlockModelType type, Predicate<class_2680> predicate, MultiPolymerBlockModel model) {
        return this.requestBlockImpl(type, predicate, false, (Either<PolymerBlockModel[], MultiPolymerBlockModel>)Either.right((Object)model));
    }

    private class_2680 requestBlockImpl(BlockModelType type, Predicate<class_2680> predicate, boolean reversed, Either<PolymerBlockModel[], MultiPolymerBlockModel> model) {
        SequencedCollection<Object> states = this.states.get((Object)type);
        if (!states.isEmpty()) {
            if (reversed) {
                states = states.reversed();
            }
            class_2680 state = null;
            for (class_2680 class_26802 : states) {
                if (!predicate.test(class_26802)) continue;
                state = class_26802;
                break;
            }
            if (state == null) {
                return null;
            }
            states.remove(state);
            this.models.put(state, model);
            this.hasRequested.add(state.method_26204());
            this.registerEvent();
            if (state.method_26204() instanceof class_3737) {
                this.blockMapper.stateMap.put(state, DefaultModelData.SPECIAL_REMAPS.getOrDefault(state, (class_2680)(state.method_26204() instanceof class_2397 ? (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)) : state.method_26204().method_9564()).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)))));
            } else {
                this.blockMapper.stateMap.put(state, DefaultModelData.SPECIAL_REMAPS.getOrDefault(state, state.method_26204() instanceof class_2397 ? (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)) : state.method_26204().method_9564()));
            }
            return state;
        }
        return null;
    }

    public int getBlocksLeft(BlockModelType type) {
        return this.states.get((Object)type).size();
    }

    public boolean hasRequestedEmpty(BlockModelType type) {
        return this.emptyBlocks.containsKey((Object)type);
    }

    private void generateResources(DefaultRPBuilder builder, List<String> credits) {
        if (CompatStatus.POLYMC && this == PolymerBlockResourceUtils.CREATOR) {
            return;
        }
        HashSet<Map.Entry<CallSite, class_2248>> keys = new HashSet<Map.Entry<CallSite, class_2248>>();
        HashMap<String, HashMap> variants = new HashMap<String, HashMap>();
        HashMap<String, List> multipart = new HashMap<String, List>();
        HashMap<String, JsonArray> bannedStates = new HashMap<String, JsonArray>();
        for (Map.Entry<class_2680, Either<PolymerBlockModel[], MultiPolymerBlockModel>> entry : this.models.entrySet()) {
            if (!this.hasRequested.contains(entry.getKey().method_26204())) continue;
            class_2680 state = entry.getKey();
            Either<PolymerBlockModel[], MultiPolymerBlockModel> models = entry.getValue();
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            String path = "assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json";
            keys.add(Map.entry(path, state.method_26204()));
            JsonArray banned = bannedStates.computeIfAbsent(path, s -> new JsonArray());
            JsonObject obj = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            JsonObject selfMulti = new JsonObject();
            for (class_2769 prop : state.method_28501()) {
                String name = prop.method_11899();
                JsonObject obj2 = new JsonObject();
                String value = prop.method_11901(state.method_11654(prop));
                obj2.addProperty(name, "!" + value);
                selfMulti.addProperty(name, value);
                jsonArray.add((JsonElement)obj2);
            }
            obj.add("OR", (JsonElement)jsonArray);
            banned.add((JsonElement)obj);
            if (models.left().isPresent()) {
                String string = PolymerBlocksInternal.generateStateName(state);
                JsonArray array = PolymerBlocksInternal.createJsonElement((PolymerBlockModel[])models.left().orElseThrow());
                variants.computeIfAbsent(path, s -> new HashMap()).put(string, array);
                continue;
            }
            for (PolymerBlockModel[] x : ((MultiPolymerBlockModel)models.right().orElseThrow()).models()) {
                JsonObject mult = new JsonObject();
                mult.add("when", (JsonElement)selfMulti);
                mult.add("apply", (JsonElement)PolymerBlocksInternal.createJsonElement(x));
                multipart.computeIfAbsent(path, s -> new ArrayList()).add(mult);
            }
        }
        for (Map.Entry<Object, Object> entry : keys) {
            String key = (String)entry.getKey();
            try {
                JsonObject modelObject = new JsonObject();
                JsonObject variantsObject = new JsonObject();
                JsonArray multipartObject = new JsonArray();
                if (variants.containsKey(key)) {
                    ArrayList values = new ArrayList(((HashMap)variants.get(key)).entrySet());
                    values.sort(Map.Entry.comparingByKey());
                    for (Map.Entry entry2 : values) {
                        variantsObject.add((String)entry2.getKey(), (JsonElement)entry2.getValue());
                    }
                }
                if (multipart.containsKey(key)) {
                    ((List)multipart.get(key)).forEach(arg_0 -> ((JsonArray)multipartObject).add(arg_0));
                    byte[] vanillaData = builder.getDataOrSource(key);
                    if (vanillaData != null) {
                        JsonObject vanillaJson = JsonParser.parseString((String)new String(vanillaData, StandardCharsets.UTF_8)).getAsJsonObject();
                        if (vanillaJson.has("variants")) {
                            ArrayList arrayList = new ArrayList(vanillaJson.get("variants").getAsJsonObject().entrySet());
                            arrayList.sort(Map.Entry.comparingByKey());
                            for (Map.Entry entry3 : arrayList) {
                                Predicate predicate = VanillaBlockPropertiesPredicate.parse(((class_2248)entry.getValue()).method_9595(), (String)entry3.getKey());
                                for (class_2680 state : ((class_2248)entry.getValue()).method_9595().method_11662()) {
                                    if (!predicate.test(state) || this.models.containsKey(state)) continue;
                                    variantsObject.add(PolymerBlocksInternal.generateStateName(state), (JsonElement)entry3.getValue());
                                }
                            }
                        }
                        if (vanillaJson.has("multipart")) {
                            for (JsonElement entry4 : vanillaJson.get("multipart").getAsJsonArray()) {
                                JsonObject jsonObject = entry4.getAsJsonObject().deepCopy();
                                JsonArray list = new JsonArray();
                                if (jsonObject.has("when")) {
                                    list.add(jsonObject.get("when"));
                                }
                                JsonObject ban2 = new JsonObject();
                                ban2.add("AND", (JsonElement)bannedStates.get(key));
                                list.add((JsonElement)ban2);
                                JsonObject when = new JsonObject();
                                when.add("AND", (JsonElement)list);
                                jsonObject.add("when", (JsonElement)when);
                                multipartObject.add((JsonElement)jsonObject);
                            }
                        }
                    }
                }
                if (!variantsObject.isEmpty()) {
                    modelObject.add("variants", (JsonElement)variantsObject);
                }
                if (!multipartObject.isEmpty()) {
                    modelObject.add("multipart", (JsonElement)multipartObject);
                }
                builder.addData(key, DefaultRPBuilder.GSON.toJson((JsonElement)modelObject).getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                PolymerImpl.LOGGER.warn("Exception occurred while building block model!", (Throwable)e);
            }
        }
    }
}

