/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.blocks.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Either;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.MultiPolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.impl.DefaultModelData;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CompatStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_11416;
import net.minecraft.class_11417;
import net.minecraft.class_11428;
import net.minecraft.class_11435;
import net.minecraft.class_11519;
import net.minecraft.class_11520;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class PolymerBlocksInternal
implements ModInitializer {
    public static Map<class_2680, Either<PolymerBlockModel[], MultiPolymerBlockModel>> modelMap = Collections.emptyMap();

    public static JsonArray createJsonElement(PolymerBlockModel[] models) {
        JsonArray array = new JsonArray();
        for (PolymerBlockModel model : models) {
            JsonObject modelObj = new JsonObject();
            modelObj.addProperty("model", model.model().toString());
            modelObj.addProperty("x", (Number)model.x());
            modelObj.addProperty("y", (Number)model.y());
            modelObj.addProperty("uvlock", Boolean.valueOf(model.uvLock()));
            modelObj.addProperty("weight", (Number)model.weight());
            array.add((JsonElement)modelObj);
        }
        return array;
    }

    public static String generateStateName(class_2680 state) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList entries = new ArrayList(state.method_11656().entrySet());
        entries.sort(Map.Entry.comparingByKey(Comparator.comparing(class_2769::method_11899)));
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuilder.append(((class_2769)entry.getKey()).method_11899()).append("=").append(((class_2769)entry.getKey()).method_11901((Comparable)entry.getValue()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public void onInitialize() {
        CommonImplUtils.registerCommands(c -> c.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"blocks_module_state_report").requires(CommonImplUtils.permission((String)"blocks_module_state_report", (int)3))).executes(ctx -> {
            if (CompatStatus.POLYMC) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"PolyMc is present! Values provided here won't reflect it's state here! Use /polymc command instead!").method_27692(class_124.field_1061));
            }
            if (((class_2168)ctx.getSource()).method_44023() != null) {
                class_5250 text = class_2561.method_43473();
                for (BlockModelType type : BlockModelType.values()) {
                    text.method_27693("- " + String.valueOf((Object)type) + " -> " + PolymerBlockResourceUtils.getBlocksLeft(type) + " / " + DefaultModelData.USABLE_STATES.get((Object)type).size() + "\n");
                }
                ((class_2168)ctx.getSource()).method_9207().method_71753(class_6880.method_40223((Object)new class_11428(new class_11417((class_2561)class_2561.method_43470((String)"States of blockstates provided by polymer-blocks module"), Optional.empty(), true, true, class_11520.field_60962, List.of(new class_11435((class_2561)text, 300)), List.of()), new class_11519(new class_11416(class_5244.field_44914, 150), Optional.empty()))));
            } else {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"States of blockstates provided by polymer-blocks module:"));
                for (BlockModelType type : BlockModelType.values()) {
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("- " + String.valueOf((Object)type) + " -> " + PolymerBlockResourceUtils.getBlocksLeft(type) + " / " + DefaultModelData.USABLE_STATES.get((Object)type).size())));
                }
            }
            return 0;
        })));
    }
}

