package eu.pb4.polymer.blocks.impl;

import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_2680;
import net.minecraft.class_7923;

public class BlockExtBlockMapper implements BlockMapper {
    public static final BlockExtBlockMapper INSTANCE = new BlockExtBlockMapper(BlockMapper.createDefault());

    public final Map<class_2680, class_2680> stateMap = new IdentityHashMap<>();
    private final BlockMapper baseMapper;

    public BlockExtBlockMapper(BlockMapper baseMapper) {
        this.baseMapper = baseMapper;
    }

    @Override
    public class_2680 toClientSideState(class_2680 state, PacketContext player) {
        if (PolymerSyncedObject.getSyncedObject(class_7923.field_41175, state.method_26204()) instanceof PolymerTexturedBlock) {
            return this.baseMapper.toClientSideState(state, player);
        }

        var parsedState = this.baseMapper.toClientSideState(state, player);
        return stateMap.getOrDefault(parsedState, parsedState);
    }

    @Override
    public String getMapperName() {
        return "polymer:textured_blocks";
    }
}
