package eu.pb4.polymer.blocks.impl;

import com.mojang.datafixers.util.Either;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.MultiPolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.core.impl.PolymerImpl;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.*;
import java.util.function.Predicate;
import net.minecraft.class_10319;
import net.minecraft.class_10597;
import net.minecraft.class_11586;
import net.minecraft.class_11598;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2323;
import net.minecraft.class_2344;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_2397;
import net.minecraft.class_2482;
import net.minecraft.class_2484;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2538;
import net.minecraft.class_2557;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2778;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_3736;
import net.minecraft.class_3737;
import net.minecraft.class_3749;
import net.minecraft.class_3922;
import net.minecraft.class_4481;
import net.minecraft.class_5172;
import net.minecraft.class_5554;
import net.minecraft.class_5703;
import net.minecraft.class_5705;
import net.minecraft.class_5803;
import net.minecraft.class_7718;
import net.minecraft.class_7923;
import net.minecraft.class_8236;

public class DefaultModelData {
    public static final Map<BlockModelType, List<class_2680>> USABLE_STATES = new EnumMap<>(BlockModelType.class);
    public static final Map<class_2680, class_2680> SPECIAL_REMAPS = new IdentityHashMap<>();
    public static final Map<class_2680, Either<PolymerBlockModel[], MultiPolymerBlockModel>> MODELS = new IdentityHashMap<>();

    private static final Predicate<class_2680> WATERLOGGED_PREDICATE = (state -> state.method_26204() instanceof class_3737 && state.method_11654(class_2741.field_12508));
    private static final Predicate<class_2680> NOT_WATERLOGGED_PREDICATE = (state -> !(state.method_26204() instanceof class_3737 && state.method_11654(class_2741.field_12508)));

    static {
        var bools = new boolean[]{false, true};

        generateDefault(BlockModelType.FULL_BLOCK, class_2246.field_10179, class_2246.field_22422);
        {
            var list = USABLE_STATES.get(BlockModelType.FULL_BLOCK);

            for (var pair : List.of(class_2246.field_20422, class_2246.field_20421)) {
                for (var dir : class_2350.class_2353.field_11062) {
                    var base = pair.method_9564().method_11657(class_4481.field_20419, dir);
                    for (int lvl = 1; lvl < 5; lvl++) {
                        var state = base.method_11657(class_4481.field_20420, lvl);
                        list.add(state);
                        SPECIAL_REMAPS.put(state, base);
                    }
                }
            }

            for (var pair : List.of(class_2246.field_10200, class_2246.field_10228)) {
                for (var dir : class_2350.values()) {
                    var base = pair.method_9564().method_11657(class_2315.field_10918, dir);
                    var state = base.method_11657(class_2315.field_10920, true);
                    list.add(state);
                    SPECIAL_REMAPS.put(state, base);
                }
            }

            for (var pair : List.of(class_2246.field_54717)) {
                for (var dir : class_2350.class_2351.values()) {
                    for (var active : class_10597.values()) {
                        var base = pair.method_9564().method_11657(class_10319.field_54739, dir).method_11657(class_10319.field_55064, active);
                        var state = base.method_11657(class_10319.field_55065, true);
                        list.add(state);
                        SPECIAL_REMAPS.put(state, base);
                    }
                }
            }

            for (var pair : List.of(
                    new class_3545<>(class_2246.field_10277, class_2246.field_10340),
                    new class_3545<>(class_2246.field_10492, class_2246.field_10445),
                    new class_3545<>(class_2246.field_10387, class_2246.field_10056),
                    new class_3545<>(class_2246.field_10480, class_2246.field_10065),
                    new class_3545<>(class_2246.field_10100, class_2246.field_10416),
                    new class_3545<>(class_2246.field_10176, class_2246.field_10552),
                    new class_3545<>(class_2246.field_29224, class_2246.field_28904),
                    new class_3545<>(class_2246.field_27133, class_2246.field_27119),
                    new class_3545<>(class_2246.field_27135, class_2246.field_27118),
                    new class_3545<>(class_2246.field_27134, class_2246.field_27117),
                    new class_3545<>(class_2246.field_33407, class_2246.field_27116),
                    new class_3545<>(class_2246.field_27138, class_2246.field_27124),
                    new class_3545<>(class_2246.field_27137, class_2246.field_27123),
                    new class_3545<>(class_2246.field_27136, class_2246.field_27122),
                    new class_3545<>(class_2246.field_33408, class_2246.field_27121)
            )) {
                for (var state : pair.method_15442().method_9595().method_11662()) {
                    list.add(state);
                    SPECIAL_REMAPS.put(state, pair.method_15441().method_34725(state));
                }
            }
        }
        generateDefault(BlockModelType.BIOME_TRANSPARENT_BLOCK, NOT_WATERLOGGED_PREDICATE, class_2246.field_10503, class_2246.field_9988, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_37551);
        generateDefault(BlockModelType.BIOME_TRANSPARENT_BLOCK_WATERLOGGED, WATERLOGGED_PREDICATE, class_2246.field_10503, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_37551);
        generateDefault(BlockModelType.TRANSPARENT_BLOCK, NOT_WATERLOGGED_PREDICATE, class_2246.field_28673, class_2246.field_28674, class_2246.field_10539, class_2246.field_9988);
        generateDefault(BlockModelType.TRANSPARENT_BLOCK_WATERLOGGED, WATERLOGGED_PREDICATE, class_2246.field_28673, class_2246.field_28674, class_2246.field_10539, class_2246.field_9988);
        generateDefault(BlockModelType.KELP_BLOCK, class_2246.field_9993);
        generateDefault(BlockModelType.CACTUS_BLOCK, class_2246.field_10029);

        {
            var farmland = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654("minecraft:block/farmland"))};
            MODELS.put(class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, 1), Either.left(farmland));
            MODELS.put(class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, 7), Either.left(new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654("minecraft:block/farmland_moist"))}));


            var list = new ReferenceArrayList<class_2680>();
            for (int i = 2; i < 7; i++) {
                var state = class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, i);
                list.add(state);
                MODELS.put(state, Either.left(farmland));
            }

            USABLE_STATES.put(BlockModelType.FARMLAND_BLOCK, list);
        }

        {
            var vines = new ReferenceArrayList<class_2680>();

            for (var block : new class_2248[]{class_2246.field_23078, class_2246.field_22123}) {
                var id = class_7923.field_41175.method_10221(block);
                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                for (var state : block.method_9595().method_11662()) {
                    MODELS.put(state, Either.left(model));
                }

                vines.addAll(block.method_9595().method_11662());
                vines.remove(block.method_9564());
            }

            {
                var id = class_7923.field_41175.method_10221(class_2246.field_28675);
                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                var model2 = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832() + "_lit"))};
                for (var state : class_2246.field_28675.method_9595().method_11662()) {
                    var berries = state.method_11654(class_5803.field_28688);
                    MODELS.put(state, Either.left(berries ? model2 : model));
                    SPECIAL_REMAPS.put(state, class_2246.field_28675.method_9564().method_11657(class_5803.field_28688, berries));
                }

                vines.addAll(class_2246.field_28675.method_9595().method_11662());
                vines.remove(class_2246.field_28675.method_9564());
                vines.remove(class_2246.field_28675.method_9564().method_11657(class_5803.field_28688, true));
            }

            USABLE_STATES.put(BlockModelType.VINES_BLOCK, vines);
        }


        {
            var plant = new ReferenceArrayList<class_2680>();

            {
                var id = class_7923.field_41175.method_10221(class_2246.field_10424);
                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                for (var state : class_2246.field_10424.method_9595().method_11662()) {
                    MODELS.put(state, Either.left(model));
                }

                plant.addAll(class_2246.field_10424.method_9595().method_11662());
                plant.remove(class_2246.field_10424.method_9564());

                USABLE_STATES.put(BlockModelType.BIOME_PLANT_BLOCK, plant);
            }
        }

        {
            var plant = new ReferenceArrayList<class_2680>();

            for (var block : new class_2248[]{class_2246.field_10394, class_2246.field_10575, class_2246.field_10217, class_2246.field_10276, class_2246.field_10385, class_2246.field_10160, class_2246.field_42727, class_2246.field_54712}) {
                var id = class_7923.field_41175.method_10221(block);

                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                for (var state : block.method_9595().method_11662()) {
                    MODELS.put(state, Either.left(model));
                }

                plant.addAll(block.method_9595().method_11662());
                plant.remove(block.method_9564());
            }

            USABLE_STATES.put(BlockModelType.PLANT_BLOCK, plant);
        }

        {
            var states = new ReferenceArrayList<class_2680>();

            for (var block : new class_2248[]{class_2246.field_10582, class_2246.field_10224}) {
                var defaultState = block.method_9564();
                var firstState = block.method_9564().method_11657(class_2557.field_11739, 1);
                for (int i = 2; i <= 15; i++) {
                    SPECIAL_REMAPS.put(defaultState.method_11657(class_2557.field_11739, i), firstState);
                }

                states.addAll(block.method_9595().method_11662());
                states.remove(defaultState);
                states.remove(firstState);
            }

            USABLE_STATES.put(BlockModelType.ACTIVE_PRESSURE_PLATE, states);
        }

        {
            var r = new ReferenceArrayList<class_2680>();
            var w = new ReferenceArrayList<class_2680>();

            for (var block : new class_2248[]{class_2246.field_23860}) {
                var state = block.method_9564().method_11657(class_3922.field_17352, false);
                for (var dir : class_2350.class_2353.field_11062) {
                    for (var signal : bools) {
                        for (var waterlogged : bools) {
                            state = state.method_11657(class_3922.field_17564, dir).method_11657(class_3922.field_17353, signal).method_11657(class_3922.field_17354, waterlogged);
                            SPECIAL_REMAPS.put(state, class_2246.field_17350.method_34725(state));
                            (waterlogged ? w : r).add(state);
                        }
                    }
                }
            }

            USABLE_STATES.put(BlockModelType.CAMPFIRE, r);
            USABLE_STATES.put(BlockModelType.CAMPFIRE_WATERLOGGED, w);
        }

        {
            var r = new ReferenceArrayList<class_2680>();

            for (var block : new class_2248[]{ class_2246.field_10432 }) {
                var state = block.method_9564().method_11657(class_2484.field_46110, true);
                for (int i = 0; i <= class_7718.method_45478(); i++) {
                    state = state.method_11657(class_2484.field_11505, i);
                    SPECIAL_REMAPS.put(state, state.method_11657(class_2484.field_46110, false));
                    r.add(state);
                }
            }

            USABLE_STATES.put(BlockModelType.HEAD, r);
        }

        {
            record Bound(BlockModelType type, class_2350 direction, class_2760 blockHalf, class_2778 shape, boolean waterlogged, ReferenceArrayList<class_2680> list) { }

            var bounds = new ArrayList<Bound>();

            for (var dir : class_2350.class_2353.field_11062) {
                for (var half : class_2760.values()) {
                    for (var shape : class_2778.values()) {
                        for (var waterlogged : bools) {
                            var b = new Bound(BlockModelType.getStairs(dir, half, shape, waterlogged), dir, half, shape, waterlogged, new ReferenceArrayList<>());
                            bounds.add(b);
                            USABLE_STATES.put(b.type, b.list);
                        }
                    }
                }
            }

            for (var block : List.of(
                    new class_3545<>(class_2246.field_27167, class_2246.field_27128),
                    new class_3545<>(class_2246.field_27166, class_2246.field_27127),
                    new class_3545<>(class_2246.field_27139, class_2246.field_27126),
                    new class_3545<>(class_2246.field_33409, class_2246.field_27125)
            )) {
                for (var bound : bounds) {
                    var state = block.method_15442().method_9564()
                            .method_11657(class_2510.field_11571, bound.direction)
                            .method_11657(class_2510.field_11572, bound.blockHalf)
                            .method_11657(class_2510.field_11565, bound.shape)
                            .method_11657(class_2510.field_11573, bound.waterlogged());
                    SPECIAL_REMAPS.put(state, block.method_15441().method_34725(state));
                    bound.list.add(state);
                }
            }
        }

        {
            record Bound(BlockModelType type, class_2350 direction, boolean waterlogged, ReferenceArrayList<class_2680> list) {}

            var bounds = new ArrayList<Bound>();

            for (var dir : class_2350.class_2353.field_11062) {
                bounds.add(new Bound(BlockModelType.getShelf(dir, false), dir, false, new ReferenceArrayList<>()));
                bounds.add(new Bound(BlockModelType.getShelf(dir, true), dir, true, new ReferenceArrayList<>()));
            }

            for (var block : List.of(
                    class_2246.field_61371, 
                    class_2246.field_61373, 
                    class_2246.field_61369, 
                    class_2246.field_61375, 
                    class_2246.field_61368, 
                    class_2246.field_61370,
                    class_2246.field_61376,
                    class_2246.field_61372,
                    class_2246.field_61366,
                    class_2246.field_61374
            )) {
                for (var chain : class_11598.values()) {
                    if (chain == class_11598.field_61446) {
                        continue;
                    }
                    for (var bound : bounds) {
                        var state = block.method_9564().method_11657(class_11586.field_61426, chain).method_11657(class_11586.field_61425, bound.direction())
                                .method_11657(class_11586.field_61427, bound.waterlogged()).method_11657(class_11586.field_61424, false);
                        SPECIAL_REMAPS.put(state, state.method_11657(class_11586.field_61426, class_11598.field_61446));
                        bound.list.add(state);
                    }
                }
            }

            for (var b : bounds) {
                USABLE_STATES.put(b.type(), b.list());
            }
        }


        {
            var x = new ReferenceArrayList<class_2680>();
            var y = new ReferenceArrayList<class_2680>();
            var z = new ReferenceArrayList<class_2680>();
            var xw = new ReferenceArrayList<class_2680>();
            var yw = new ReferenceArrayList<class_2680>();
            var zw = new ReferenceArrayList<class_2680>();

            var pairs = List.of(
                    new class_3545<>(class_2246.field_61384, class_2246.field_27171),
                    new class_3545<>(class_2246.field_61385, class_2246.field_61381),
                    new class_3545<>(class_2246.field_61386, class_2246.field_61382),
                    new class_3545<>(class_2246.field_61387, class_2246.field_61383)
            );

            for (var pair : pairs) {
                for (var powered : bools) {
                    for (var waterlogged : bools) {
                        for (var dir : class_2350.values()) {
                            var list = switch (dir.method_10166()) {
                                case field_11048 -> waterlogged ? xw : x;
                                case field_11052 -> waterlogged ? yw : y;
                                case field_11051 -> waterlogged ? zw : z;
                            };

                            var state = pair.method_15442().method_9564()
                                    .method_11657(class_5554.field_27193, powered)
                                    .method_11657(class_5554.field_29562, waterlogged)
                                    .method_11657(class_5554.field_10927, dir);

                            var base = powered ? class_2246.field_27171 : pair.method_15441();

                            list.add(state);
                            SPECIAL_REMAPS.put(state, base.method_34725(state));

                            if (powered && pair.method_15441() != class_2246.field_27171) {
                                state = pair.method_15441().method_34725(state);
                                list.add(state);
                                SPECIAL_REMAPS.put(state, base.method_34725(state));
                            }
                        }
                    }
                }
            }

            USABLE_STATES.put(BlockModelType.LIGHTNING_ROD_X, x);
            USABLE_STATES.put(BlockModelType.LIGHTNING_ROD_Y, y);
            USABLE_STATES.put(BlockModelType.LIGHTNING_ROD_Z, z);
            USABLE_STATES.put(BlockModelType.LIGHTNING_ROD_X_WATERLOGGED, xw);
            USABLE_STATES.put(BlockModelType.LIGHTNING_ROD_Y_WATERLOGGED, yw);
            USABLE_STATES.put(BlockModelType.LIGHTNING_ROD_Z_WATERLOGGED, zw);
        }

        {
            var x = new ReferenceArrayList<class_2680>();
            var y = new ReferenceArrayList<class_2680>();
            var z = new ReferenceArrayList<class_2680>();
            var xw = new ReferenceArrayList<class_2680>();
            var yw = new ReferenceArrayList<class_2680>();
            var zw = new ReferenceArrayList<class_2680>();

            for (var pair : class_2246.field_61905.method_73126().entrySet()) {
                for (var waterlogged : bools) {
                    for (var dir : class_2350.class_2351.values()) {
                        var list = switch (dir) {
                            case field_11048 -> waterlogged ? xw : x;
                            case field_11052 -> waterlogged ? yw : y;
                            case field_11051 -> waterlogged ? zw : z;
                        };

                        var state = pair.getValue().method_9564()
                                .method_11657(class_5172.field_24411, waterlogged)
                                .method_11657(class_5172.field_11459, dir);

                        list.add(state);
                        SPECIAL_REMAPS.put(state, pair.getKey().method_34725(state));
                    }

                }
            }

            USABLE_STATES.put(BlockModelType.CHAIN_X, x);
            USABLE_STATES.put(BlockModelType.CHAIN_Y, y);
            USABLE_STATES.put(BlockModelType.CHAIN_Z, z);
            USABLE_STATES.put(BlockModelType.CHAIN_X_WATERLOGGED, xw);
            USABLE_STATES.put(BlockModelType.CHAIN_Y_WATERLOGGED, yw);
            USABLE_STATES.put(BlockModelType.CHAIN_Z_WATERLOGGED, zw);
        }

        {
            record Bound(BlockModelType type, List<class_2746> properties, ReferenceArrayList<class_2680> list) {}
            var bounds = new ArrayList<Bound>();

            var properties = new class_2746[] {
                    class_2389.field_10900,
                    class_2389.field_10905,
                    class_2389.field_10904,
                    class_2389.field_10903,
                    class_2389.field_10907,
            };

            for (var i = 0; i < 32; i++) {
                var b = new Bound(BlockModelType.values()[BlockModelType.BARS_CENTER.ordinal() + i], new ArrayList<>(), new ReferenceArrayList<>());
                USABLE_STATES.put(b.type(), b.list());

                for (int a = 0; a < properties.length; a++) {
                    if (((i >> a) & 1) == 1) {
                        b.properties.add(properties[a]);
                    }
                }

                bounds.add(b);
            }

            for (var pair : class_2246.field_61904.method_73126().entrySet()) {
                for (var b : bounds) {
                    var state = pair.getValue().method_9564();
                    for (var p : b.properties) {
                        state = state.method_11657(p, true);
                    }
                    b.list.add(state);
                    SPECIAL_REMAPS.put(state, pair.getKey().method_34725(state));
                }
            }
        }

        {
            var r = new ReferenceArrayList<class_2680>();
            var h = new ReferenceArrayList<class_2680>();
            var rw = new ReferenceArrayList<class_2680>();
            var hw = new ReferenceArrayList<class_2680>();

            for (var pair : class_2246.field_61906.method_73126().entrySet()) {
                for (var hanging : bools) {
                    for (var waterlogged : bools) {
                        var list = hanging ? (waterlogged ? hw : h) : (waterlogged ? rw : r);

                        var state = pair.getValue().method_9564()
                                .method_11657(class_3749.field_26441, waterlogged)
                                .method_11657(class_3749.field_16545, hanging);

                        list.add(state);
                        SPECIAL_REMAPS.put(state, pair.getKey().method_34725(state));
                    }
                }
            }

            USABLE_STATES.put(BlockModelType.LANTERN, r);
            USABLE_STATES.put(BlockModelType.LANTERN_HANGING, h);
            USABLE_STATES.put(BlockModelType.LANTERN_WATERLOGGED, rw);
            USABLE_STATES.put(BlockModelType.LANTERN_HANGING_WATERLOGGED, hw);
        }

        {
            addDisarmedTripwire(false, BlockModelType.TRIPWIRE_BLOCK);
            addDisarmedTripwire(true, BlockModelType.TRIPWIRE_BLOCK_FLAT);

            addSlabs(class_2771.field_12679, false, BlockModelType.TOP_SLAB);
            addSlabs(class_2771.field_12679, true, BlockModelType.TOP_SLAB_WATERLOGGED);
            addSlabs(class_2771.field_12681, false, BlockModelType.BOTTOM_SLAB);
            addSlabs(class_2771.field_12681, true, BlockModelType.BOTTOM_SLAB_WATERLOGGED);

            var fullSlabs = List.<class_3545<class_2248, class_2248>>of(
                    new class_3545<>(class_2246.field_55056, class_2246.field_55054),
                    new class_3545<>(class_2246.field_10389, class_2246.field_10135),
                    new class_3545<>(class_2246.field_10236, class_2246.field_10006),
                    new class_3545<>(class_2246.field_10623, class_2246.field_10297),
                    new class_3545<>(class_2246.field_10119, class_2246.field_10161),
                    new class_3545<>(class_2246.field_10071, class_2246.field_9975),
                    new class_3545<>(class_2246.field_10257, class_2246.field_10148),
                    new class_3545<>(class_2246.field_10617, class_2246.field_10334),
                    new class_3545<>(class_2246.field_10031, class_2246.field_10218),
                    new class_3545<>(class_2246.field_42746, class_2246.field_42751),
                    new class_3545<>(class_2246.field_10500, class_2246.field_10075),
                    new class_3545<>(class_2246.field_54727, class_2246.field_54735),
                    new class_3545<>(class_2246.field_37564, class_2246.field_37577),
                    new class_3545<>(class_2246.field_40292, class_2246.field_40294),
                    new class_3545<>(class_2246.field_40293, class_2246.field_40295),
                    new class_3545<>(class_2246.field_10454, class_2246.field_10340),
                    new class_3545<>(class_2246.field_10007, class_2246.field_9979),
                    new class_3545<>(class_2246.field_18890, class_2246.field_10361),
                    new class_3545<>(class_2246.field_10298, class_2246.field_10161),
                    new class_3545<>(class_2246.field_10351, class_2246.field_10445),
                    new class_3545<>(class_2246.field_10191, class_2246.field_10104),
                    new class_3545<>(class_2246.field_10131, class_2246.field_10056),
                    new class_3545<>(class_2246.field_37562, class_2246.field_37557),
                    new class_3545<>(class_2246.field_10390, class_2246.field_10266),
                    new class_3545<>(class_2246.field_10237, class_2246.field_10153),
                    new class_3545<>(class_2246.field_10624, class_2246.field_10344),
                    new class_3545<>(class_2246.field_18891, class_2246.field_10518),
                    new class_3545<>(class_2246.field_10175, class_2246.field_10286),
                    new class_3545<>(class_2246.field_10329, class_2246.field_10289),
                    new class_3545<>(class_2246.field_10283, class_2246.field_10483),
                    new class_3545<>(class_2246.field_10024, class_2246.field_10065),
                    new class_3545<>(class_2246.field_10412, class_2246.field_10346),
                    new class_3545<>(class_2246.field_10405, class_2246.field_9989),
                    new class_3545<>(class_2246.field_10064, class_2246.field_10462),
                    new class_3545<>(class_2246.field_10262, class_2246.field_10467),
                    new class_3545<>(class_2246.field_10601, class_2246.field_9978),
                    new class_3545<>(class_2246.field_10189, class_2246.field_10474),
                    new class_3545<>(class_2246.field_10016, class_2246.field_10115),
                    new class_3545<>(class_2246.field_10478, class_2246.field_9986),
                    new class_3545<>(class_2246.field_10322, class_2246.field_10093),
                    new class_3545<>(class_2246.field_10507, class_2246.field_10508),
                    new class_3545<>(class_2246.field_22128, class_2246.field_22126),
                    new class_3545<>(class_2246.field_22129, class_2246.field_22127),
                    new class_3545<>(class_2246.field_23872, class_2246.field_23869),
                    new class_3545<>(class_2246.field_23877, class_2246.field_23874),
                    new class_3545<>(class_2246.field_23862, class_2246.field_23873),
                    new class_3545<>(class_2246.field_47027, class_2246.field_27165),
                    new class_3545<>(class_2246.field_47031, class_2246.field_47030),
                    new class_3545<>(class_2246.field_47036, class_2246.field_47035),
                    new class_3545<>(class_2246.field_27129, class_2246.field_27121),
                    new class_3545<>(class_2246.field_27130, class_2246.field_27122),
                    new class_3545<>(class_2246.field_27131, class_2246.field_27123),
                    new class_3545<>(class_2246.field_27132, class_2246.field_27124),
                    new class_3545<>(class_2246.field_33410, class_2246.field_27121),
                    new class_3545<>(class_2246.field_27168, class_2246.field_27122),
                    new class_3545<>(class_2246.field_27169, class_2246.field_27123),
                    new class_3545<>(class_2246.field_27170, class_2246.field_27124),
                    new class_3545<>(class_2246.field_28890, class_2246.field_29031),
                    new class_3545<>(class_2246.field_28894, class_2246.field_28892),
                    new class_3545<>(class_2246.field_28898, class_2246.field_28896),
                    new class_3545<>(class_2246.field_28902, class_2246.field_28900)
            );

            var fullRefs = USABLE_STATES.get(BlockModelType.FULL_BLOCK);
            for (var pair : fullSlabs) {
                addSlab(class_2771.field_12682, false, pair.method_15441(), pair.method_15442(), fullRefs);
            }

            for (var pair : fullSlabs) {
                addSlab(class_2771.field_12682, true, pair.method_15441(), pair.method_15442(), fullRefs);
            }
        }

        {
            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12619, false, BlockModelType.NORTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12619, false, BlockModelType.EAST_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12619, false, BlockModelType.SOUTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12619, false, BlockModelType.WEST_TRAPDOOR);

            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12619, true, BlockModelType.NORTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12619, true, BlockModelType.EAST_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12619, true, BlockModelType.SOUTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12619, true, BlockModelType.WEST_TRAPDOOR_WATERLOGGED);

            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12617, false, BlockModelType.NORTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12617, false, BlockModelType.EAST_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12617, false, BlockModelType.SOUTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12617, false, BlockModelType.WEST_TRAPDOOR);

            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12617, true, BlockModelType.NORTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12617, true, BlockModelType.EAST_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12617, true, BlockModelType.SOUTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12617, true, BlockModelType.WEST_TRAPDOOR_WATERLOGGED);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
        }

        {
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.NORTH_DOOR, list);
            }
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.EAST_DOOR, list);
            }
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.SOUTH_DOOR, list);
            }
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.WEST_DOOR, list);
            }
        }

        {
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addSculkBlocks(false, false, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.SCULK_SENSOR_BLOCK, list);
            }
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addSculkBlocks(true, false, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.SCULK_SENSOR_BLOCK_WATERLOGGED, list);
            }
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addSculkBlocks(false, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.ACTIVE_SCULK_SENSOR_BLOCK, list);
            }
            {
                List<class_2680> list = new ReferenceArrayList<>();
                addSculkBlocks(true, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.ACTIVE_SCULK_SENSOR_BLOCK_WATERLOGGED, list);
            }
        }

        {
            addScaffolding(false, false, BlockModelType.TOP_SCAFFOLDING);
            addScaffolding(true, false, BlockModelType.BOTTOM_SCAFFOLDING);
            addScaffolding(false, true, BlockModelType.TOP_SCAFFOLDING_WATERLOGGED);
            addScaffolding(true, true, BlockModelType.BOTTOM_SCAFFOLDING_WATERLOGGED);
        }
        {
            addFenceGates(class_2246.field_10457, class_2246.field_40289, class_2246.field_10513,
                    class_2246.field_42745, class_2246.field_22096, class_2246.field_10196,
                    class_2246.field_10041, class_2246.field_37563, class_2246.field_10188,
                    class_2246.field_54730, class_2246.field_10291, class_2246.field_22097);
        }

        if (false) {
            PolymerImpl.LOGGER.info("===== Available States =====");
            for (var model : BlockModelType.values()) {
                PolymerImpl.LOGGER.info("{}: {}", model.name(), USABLE_STATES.get(model).size());

            }
        }
    }

    private static void addSculkBlocks(boolean waterlogged, boolean active, List<class_2680> list) {
        for (var phase : class_5705.values()) {
            if ((phase == class_5705.field_28122) != active) continue;
            for (int i = 1; i <= 15; i++) {
                var defaultState = class_2246.field_28108.method_9564().method_11657(class_5703.field_28111, phase).method_11657(class_5703.field_28113, waterlogged);
                var from = defaultState.method_11657(class_5703.field_28112, i);
                list.add(from);
                DefaultModelData.SPECIAL_REMAPS.put(from, defaultState);
            }
        }

        var facingDirs = new class_2350[]{
                class_2350.field_11043,
                class_2350.field_11034,
                class_2350.field_11035,
                class_2350.field_11039
        };

        for (var direction : facingDirs) {
            for (var phase : class_5705.values()) {
                if ((phase == class_5705.field_28122) != active) continue;
                for (int i = 1; i <= 15; i++) {
                    var defaultState = class_2246.field_43231.method_9564().method_11657(class_5703.field_28111, phase).method_11657(class_5703.field_28113, waterlogged).method_11657(class_8236.field_43235, direction);
                    var from = defaultState.method_11657(class_5703.field_28112, i);
                    list.add(from);
                    DefaultModelData.SPECIAL_REMAPS.put(from, defaultState);
                }
            }
        }
    }

    private static void addDoor(class_2350 direction, class_2750 doorHinge, class_2756 doubleBlockHalf, boolean open, List<class_2680> list) {
        list.add(addSingleDoor(class_2246.field_47040, class_2246.field_47044, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSingleDoor(class_2246.field_47043, class_2246.field_47047, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSingleDoor(class_2246.field_47041, class_2246.field_47045, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSingleDoor(class_2246.field_47042, class_2246.field_47046, direction, doorHinge, doubleBlockHalf, open));

        list.add(addSinglePoweredDoor(class_2246.field_10232, class_2246.field_10232, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_40291, class_2246.field_40291, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10352, class_2246.field_10352, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_42748, class_2246.field_42748, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_22102, class_2246.field_22102, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10403, class_2246.field_10403, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10627, class_2246.field_10627, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_37566, class_2246.field_37566, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10149, class_2246.field_10149, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10521, class_2246.field_10521, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_22103, class_2246.field_22103, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_54729, class_2246.field_54729, direction, doorHinge, doubleBlockHalf, open));

        list.add(addSinglePoweredDoor(class_2246.field_47044, class_2246.field_47044, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_47047, class_2246.field_47047, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_47045, class_2246.field_47045, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_47046, class_2246.field_47046, direction, doorHinge, doubleBlockHalf, open));

        list.add(addSinglePoweredDoor(class_2246.field_9973, class_2246.field_9973, direction, doorHinge, doubleBlockHalf, open));
    }

    private static class_2680 addSinglePoweredDoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2750 hinge, class_2756 half, boolean open) {
        class_2680 from = block.method_9564().method_11657(class_2323.field_10940, true).method_11657(class_2323.field_10945, open).method_11657(class_2323.field_10938, facing).method_11657(class_2323.field_10946, half).method_11657(class_2323.field_10941, hinge);
        class_2680 to = replacement.method_34725(from).method_11657(class_2323.field_10940, false);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSingleDoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2750 hinge, class_2756 half, boolean open) {
        class_2680 from = block.method_9564().method_11657(class_2323.field_10940, false).method_11657(class_2323.field_10945, open).method_11657(class_2323.field_10938, facing).method_11657(class_2323.field_10946, half).method_11657(class_2323.field_10941, hinge);
        class_2680 to = replacement.method_34725(from);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static void addTrapdoorHalf(class_2350 facing, class_2760 half, boolean waterlogged, BlockModelType modelType) {
        var list = USABLE_STATES.computeIfAbsent(modelType, x -> new ReferenceArrayList<>());
        list.add(addSingleClosedTrapdoor(class_2246.field_47048, class_2246.field_47052, facing, half, waterlogged));
        list.add(addSingleClosedTrapdoor(class_2246.field_47049, class_2246.field_47053, facing, half, waterlogged));
        list.add(addSingleClosedTrapdoor(class_2246.field_47051, class_2246.field_47063, facing, half, waterlogged));
        list.add(addSingleClosedTrapdoor(class_2246.field_47050, class_2246.field_47062, facing, half, waterlogged));

        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10608, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_40285, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10486, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_42740, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_22094, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10246, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10017, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_37555, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10137, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10323, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_22095, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_54723, facing, half, waterlogged));

        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_47052, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_47053, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_47063, facing, half, waterlogged));
        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_47062, facing, half, waterlogged));

        list.add(addSinglePoweredClosedTrapdoor(class_2246.field_10453, facing, half, waterlogged));
    }

    private static void addTrapdoorDirection(class_2350 facing, class_2760 half, boolean waterlogged, BlockModelType modelType) {
        var list = USABLE_STATES.computeIfAbsent(modelType, x -> new ReferenceArrayList<>());

        list.add(addSingleOpenTrapdoor(class_2246.field_47048, class_2246.field_47052, facing, half, waterlogged));
        list.add(addSingleOpenTrapdoor(class_2246.field_47049, class_2246.field_47053, facing, half, waterlogged));
        list.add(addSingleOpenTrapdoor(class_2246.field_47051, class_2246.field_47063, facing, half, waterlogged));
        list.add(addSingleOpenTrapdoor(class_2246.field_47050, class_2246.field_47062, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10608, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_40285, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10486, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_42740, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_22094, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10246, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10017, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_37555, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10137, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10323, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_22095, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_54723, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47052, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47053, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47063, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47062, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10453, facing, half, waterlogged));
    }

    private static class_2680 addSingleOpenTrapdoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, true).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = replacement.method_34725(from);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSingleClosedTrapdoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, false).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = replacement.method_34725(from);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSinglePoweredOpenTrapdoor(class_2248 block, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, true).method_11657(class_2533.field_11629, true).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = from.method_11657(class_2533.field_11629, false);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSinglePoweredClosedTrapdoor(class_2248 block, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, false).method_11657(class_2533.field_11629, true).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = from.method_11657(class_2533.field_11629, false);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static void addSlabs(class_2771 slabType, boolean waterlogged, BlockModelType modelType) {
        var list = USABLE_STATES.computeIfAbsent(modelType, x -> new ReferenceArrayList<>());

        addSlab(slabType, waterlogged, class_2246.field_27132, class_2246.field_27170, list);
        addSlab(slabType, waterlogged, class_2246.field_27131, class_2246.field_27169, list);
        addSlab(slabType, waterlogged, class_2246.field_27130, class_2246.field_27168, list);
        addSlab(slabType, waterlogged, class_2246.field_27129, class_2246.field_33410, list);

        addSlab(slabType, waterlogged, class_2246.field_10119, class_2246.field_10298, list);
    }

    private static void addSlab(class_2771 slabType, boolean waterlogged, class_2248 to, class_2248 from, List<class_2680> list) {
        class_2680 state = from.method_9564().method_11657(class_2482.field_11502, waterlogged).method_11657(class_2482.field_11501, slabType);
        list.add(state);
        DefaultModelData.SPECIAL_REMAPS.put(state, to.method_34725(state));
    }

    private static void addDisarmedTripwire(boolean attached, BlockModelType modelType) {
        var list = USABLE_STATES.computeIfAbsent(modelType, x -> new ReferenceArrayList<>());
        // generate all permutations of north, south, east, west, powered
        {
            var base = class_2246.field_10589.method_9564().method_11657(class_2538.field_11679, true);
            var booleans = new boolean[]{true, false};
            for (boolean north : booleans) {
                for (boolean south : booleans) {
                    for (boolean east : booleans) {
                        for (boolean west : booleans) {
                            for (boolean powered : booleans) {
                                class_2680 state = base
                                        .method_11657(class_2538.field_11683, attached)
                                        .method_11657(class_2538.field_11675, north)
                                        .method_11657(class_2538.field_11678, south)
                                        .method_11657(class_2538.field_11673, east)
                                        .method_11657(class_2538.field_11674, west)
                                        .method_11657(class_2538.field_11680, powered);
                                list.add(state);
                                DefaultModelData.SPECIAL_REMAPS.put(state, state.method_11657(class_2538.field_11679, false).method_11657(class_2538.field_11680, false));
                            }
                        }
                    }
                }
            }
        }
    }

    private static void addScaffolding(boolean bottom, boolean waterlogged, BlockModelType modelType) {

        var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654("minecraft:block/scaffolding_" + (bottom ? "unstable" : "stable")))};
        var list = USABLE_STATES.computeIfAbsent(modelType, x -> new ReferenceArrayList<>());

        for (int i = 0; i <= 7; i++) {
            var state = class_2246.field_16492.method_9564()
                    .method_11657(class_3736.field_16547, bottom)
                    .method_11657(class_3736.field_16496, waterlogged)
                    .method_11657(class_3736.field_16495, i);

            MODELS.put(state, Either.left(model));

            if (i != 7 && !(bottom && i == 0)) {
                list.add(state);
                SPECIAL_REMAPS.put(state, state.method_11657(class_3736.field_16495, 7));
            }
        }
    }

    private static void addFenceGates(class_2248... blocks) {
        for (class_2248 base : blocks) {
            addFenceGates(base, true, true, true, BlockModelType.NORTH_SOUTH_INWALL_OPEN_GATE);
            addFenceGates(base, true, true, false, BlockModelType.NORTH_SOUTH_INWALL_GATE);
            addFenceGates(base, true, false, true, BlockModelType.NORTH_SOUTH_OPEN_GATE);
            addFenceGates(base, true, false, false, BlockModelType.NORTH_SOUTH_GATE);
            addFenceGates(base, false, true, true, BlockModelType.EAST_WEST_INWALL_OPEN_GATE);
            addFenceGates(base, false, true, false, BlockModelType.EAST_WEST_INWALL_GATE);
            addFenceGates(base, false, false, true, BlockModelType.EAST_WEST_OPEN_GATE);
            addFenceGates(base, false, false, false, BlockModelType.EAST_WEST_GATE);
        }
    }

    private static void addFenceGates(class_2248 base, boolean northSouth, boolean inWall, boolean open, BlockModelType modelType) {
        var list = USABLE_STATES.computeIfAbsent(modelType, x -> new ReferenceArrayList<>());

        var directions = northSouth ? new class_2350[]{class_2350.field_11043, class_2350.field_11035} : new class_2350[]{class_2350.field_11034, class_2350.field_11039};
        for (class_2350 direction : directions) {
            var state = base.method_9564()
                    .method_11657(class_2349.field_11024, inWall)
                    .method_11657(class_2349.field_11026, open)
                    .method_11657(class_2349.field_11021, true)
                    .method_11657(class_2349.field_11177, direction);
            list.add(state);
            SPECIAL_REMAPS.put(state, state.method_11657(class_2349.field_11021, false));
        }
    }

    private static void generateDefault(BlockModelType type, class_2248... blocks) {
        generateDefault(type, (b) -> true, blocks);
    }

    private static void generateDefault(BlockModelType type, Predicate<class_2680> shouldInclude, class_2248... blocks) {
        var list = USABLE_STATES.computeIfAbsent(type, x -> new ReferenceArrayList<>());

        for (var block : blocks) {
            var id = class_7923.field_41175.method_10221(block);
            var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
            for (var state : block.method_9595().method_11662()) {
                MODELS.put(state, Either.left(model));
                if (shouldInclude.test(state)) {
                    list.add(state);
                }
            }

            if (block instanceof class_2397) {
                list.remove(block.method_9564().method_11657(class_2397.field_11200, true));
                list.remove(block.method_9564().method_11657(class_2397.field_11200, true).method_11657(class_2397.field_38227, true));
            } else {
                list.remove(block.method_9564());
            }
        }
    }
}
