package eu.pb4.polymer.blocks.api;

import eu.pb4.polymer.core.api.block.PolymerBlock;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.api.utils.PolymerUtils;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_12079;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_8685;
import net.minecraft.class_9296;


public interface PolymerTexturedHeadBlock extends PolymerTexturedBlock {
    class_9296 EMPTY_TEXTURE = PolymerUtils.createProfileComponent(new class_8685.class_11892(Optional.of(
            new class_12079.class_10726(class_2960.method_60655("polymer", "block/empty"))), Optional.empty(), Optional.empty(), Optional.empty()));

    @Override
    default void onPolymerBlockSend(class_2680 blockState, class_2338.class_2339 pos, PacketContext.NotNullWithPlayer context) {
        class_2487 main = new class_2487();
        main.method_10582("id", "minecraft:skull");
        main.method_10566("profile", class_9296.field_49359.encodeStart(class_2509.field_11560, EMPTY_TEXTURE).result().get());
        main.method_10569("x", pos.method_10263());
        main.method_10569("y", pos.method_10264());
        main.method_10569("z", pos.method_10260());
        Objects.requireNonNull(context.getPlayer()).field_13987.method_14364(PolymerBlockUtils.createBlockEntityPacket(pos.method_10062(), class_2591.field_11913, main));
    }
}
