package eu.pb4.polymer.blocks.impl;

import com.google.common.base.Splitter;
import org.jetbrains.annotations.Nullable;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;

public class VanillaBlockPropertiesPredicate {
    private static final Splitter COMMA_SPLITTER = Splitter.on(',');
    private static final Splitter EQUAL_SIGN_SPLITTER = Splitter.on('=').limit(2);

    public static <O, S extends class_2688<O, S>> Predicate<class_2688<O, S>> parse(class_2689<O, S> stateManager, String string) {
        var map = new HashMap<class_2769<?>, Comparable<?>>();
        var parts = COMMA_SPLITTER.split(string).iterator();

        while (true) {
            Iterator<String> keyValIterator;
            do {
                if (!parts.hasNext()) {
                    return (state) -> {
                        var var2 = map.entrySet().iterator();

                        Map.Entry<class_2769<?>, Comparable<?>> entry;
                        do {
                            if (!var2.hasNext()) {
                                return true;
                            }

                            entry = var2.next();
                        } while (Objects.equals(state.method_11654((class_2769) entry.getKey()), entry.getValue()));

                        return false;
                    };
                }

                String string2 = parts.next();
                keyValIterator = EQUAL_SIGN_SPLITTER.split(string2).iterator();
            } while (!keyValIterator.hasNext());

            var key = keyValIterator.next();
            var property = stateManager.method_11663(key);
            if (property != null && keyValIterator.hasNext()) {
                String val = keyValIterator.next();
                var comparable = parse(property, val);
                if (comparable == null) {
                    continue;
                }

                map.put(property, comparable);
            }
        }
    }

    @Nullable
    private static <T extends Comparable<T>> T parse(class_2769<T> property, String value) {
        return property.method_11900(value).orElse(null);
    }
}