package eu.pb4.polymer.blocks.impl;

import ;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.core.impl.PolymerImpl;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.block.*;
import net.minecraft.block.enums.*;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2482;
import net.minecraft.class_2533;
import net.minecraft.class_2538;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2750;
import net.minecraft.class_2756;
import net.minecraft.class_2760;
import net.minecraft.class_2771;
import net.minecraft.class_2960;
import net.minecraft.class_3737;
import net.minecraft.class_5703;
import net.minecraft.class_5705;
import net.minecraft.class_5803;
import net.minecraft.class_7923;
import net.minecraft.class_8236;
import java.util.*;
import java.util.function.Predicate;

public class DefaultModelData {
    public static final Map<BlockModelType, List<class_2680>> USABLE_STATES = new EnumMap<>(BlockModelType.class);
    public static final Map<class_2680, class_2680> SPECIAL_REMAPS = new IdentityHashMap<>();
    public static final Map<class_2680, PolymerBlockModel[]> MODELS = new IdentityHashMap<>();

    private static final Predicate<class_2680> WATERLOGGED_PREDICATE = (state -> state.method_26204() instanceof class_3737 && state.method_11654(class_2741.field_12508));
    private static final Predicate<class_2680> NOT_WATERLOGGED_PREDICATE = (state -> !(state.method_26204() instanceof class_3737 && state.method_11654(class_2741.field_12508)));

    static {
        generateDefault(BlockModelType.FULL_BLOCK, class_2246.field_10179);
        generateDefault(BlockModelType.BIOME_TRANSPARENT_BLOCK, NOT_WATERLOGGED_PREDICATE, class_2246.field_10503, class_2246.field_9988, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_37551);
        generateDefault(BlockModelType.BIOME_TRANSPARENT_BLOCK_WATERLOGGED, WATERLOGGED_PREDICATE, class_2246.field_10503, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_37551);
        generateDefault(BlockModelType.TRANSPARENT_BLOCK, NOT_WATERLOGGED_PREDICATE, class_2246.field_28673, class_2246.field_28674, class_2246.field_10539, class_2246.field_9988);
        generateDefault(BlockModelType.TRANSPARENT_BLOCK_WATERLOGGED, WATERLOGGED_PREDICATE, class_2246.field_28673, class_2246.field_28674, class_2246.field_10539, class_2246.field_9988);
        generateDefault(BlockModelType.KELP_BLOCK, class_2246.field_9993);
        generateDefault(BlockModelType.CACTUS_BLOCK, class_2246.field_10029);

        {
            var farmland = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654("minecraft:block/farmland"))};
            MODELS.put(class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, 1), farmland);
            MODELS.put(class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, 7), new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654("minecraft:block/farmland_moist"))});


            var list = new ArrayList<class_2680>();
            for (int i = 2; i < 7; i++) {
                var state = class_2246.field_10362.method_9564().method_11657(class_2344.field_11009, i);
                list.add(state);
                MODELS.put(state, farmland);
            }

            USABLE_STATES.put(BlockModelType.FARMLAND_BLOCK, list);
        }

        {
            var vines = new ArrayList<class_2680>();

            for (var block : new class_2248[]{class_2246.field_23078, class_2246.field_22123}) {
                var id = class_7923.field_41175.method_10221(block);
                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                for (var state : block.method_9595().method_11662()) {
                    MODELS.put(state, model);
                }

                vines.addAll(block.method_9595().method_11662());
                vines.remove(block.method_9564());
            }

            {
                var id = class_7923.field_41175.method_10221(class_2246.field_28675);
                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                var model2 = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832() + "_lit"))};
                for (var state : class_2246.field_28675.method_9595().method_11662()) {
                    var berries = state.method_11654(class_5803.field_28688);
                    MODELS.put(state, berries ? model2 : model);
                    SPECIAL_REMAPS.put(state, class_2246.field_28675.method_9564().method_11657(class_5803.field_28688, berries));
                }

                vines.addAll(class_2246.field_28675.method_9595().method_11662());
                vines.remove(class_2246.field_28675.method_9564());
                vines.remove(class_2246.field_28675.method_9564().method_11657(class_5803.field_28688, true));
            }

            USABLE_STATES.put(BlockModelType.VINES_BLOCK, vines);
        }


        {
            var plant = new ArrayList<class_2680>();

            {
                var id = class_7923.field_41175.method_10221(class_2246.field_10424);
                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                for (var state : class_2246.field_10424.method_9595().method_11662()) {
                    MODELS.put(state, model);
                }

                plant.addAll(class_2246.field_10424.method_9595().method_11662());
                plant.remove(class_2246.field_10424.method_9564());

                USABLE_STATES.put(BlockModelType.BIOME_PLANT_BLOCK, plant);
            }
        }

        {
            var plant = new ArrayList<class_2680>();

            for (var block : new class_2248[]{class_2246.field_10394, class_2246.field_10575, class_2246.field_10217, class_2246.field_10276, class_2246.field_10385, class_2246.field_10160, class_2246.field_42727}) {
                var id = class_7923.field_41175.method_10221(block);

                var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
                for (var state : block.method_9595().method_11662()) {
                    MODELS.put(state, model);
                }

                plant.addAll(block.method_9595().method_11662());
                plant.remove(block.method_9564());
            }

            USABLE_STATES.put(BlockModelType.PLANT_BLOCK, plant);
        }

        {
            addDisarmedTripwire(false, BlockModelType.TRIPWIRE_BLOCK);
            addDisarmedTripwire(true, BlockModelType.TRIPWIRE_BLOCK_FLAT);

            addSlabs(class_2771.field_12679, false, BlockModelType.TOP_SLAB);
            addSlabs(class_2771.field_12679, true, BlockModelType.TOP_SLAB_WATERLOGGED);
            addSlabs(class_2771.field_12681, false, BlockModelType.BOTTOM_SLAB);
            addSlabs(class_2771.field_12681, true, BlockModelType.BOTTOM_SLAB_WATERLOGGED);
        }

        {
            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12619, false, BlockModelType.NORTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12619, false, BlockModelType.EAST_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12619, false, BlockModelType.SOUTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12619, false, BlockModelType.WEST_TRAPDOOR);

            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12619, true, BlockModelType.NORTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12619, true, BlockModelType.EAST_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12619, true, BlockModelType.SOUTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12619, true, BlockModelType.WEST_TRAPDOOR_WATERLOGGED);

            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12617, false, BlockModelType.NORTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12617, false, BlockModelType.EAST_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12617, false, BlockModelType.SOUTH_TRAPDOOR);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12617, false, BlockModelType.WEST_TRAPDOOR);

            addTrapdoorDirection(class_2350.field_11043, class_2760.field_12617, true, BlockModelType.NORTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11034, class_2760.field_12617, true, BlockModelType.EAST_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11035, class_2760.field_12617, true, BlockModelType.SOUTH_TRAPDOOR_WATERLOGGED);
            addTrapdoorDirection(class_2350.field_11039, class_2760.field_12617, true, BlockModelType.WEST_TRAPDOOR_WATERLOGGED);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12619, false, BlockModelType.TOP_TRAPDOOR);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12619, true, BlockModelType.TOP_TRAPDOOR_WATERLOGGED);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12617, false, BlockModelType.BOTTOM_TRAPDOOR);

            addTrapdoorHalf(class_2350.field_11043, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11034, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11035, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
            addTrapdoorHalf(class_2350.field_11039, class_2760.field_12617, true, BlockModelType.BOTTOM_TRAPDOOR_WATERLOGGED);
        }

        {
            {
                List<class_2680> list = new ObjectArrayList<>();
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.NORTH_DOOR, list);
            }
            {
                List<class_2680> list = new ObjectArrayList<>();
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11043, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.EAST_DOOR, list);
            }
            {
                List<class_2680> list = new ObjectArrayList<>();
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11034, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.SOUTH_DOOR, list);
            }
            {
                List<class_2680> list = new ObjectArrayList<>();
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12588, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12609, false, list);
                addDoor(class_2350.field_11039, class_2750.field_12586, class_2756.field_12607, false, list);
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11035, class_2750.field_12588, class_2756.field_12607, true, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12609, true, list);
                addDoor(class_2350.field_11043, class_2750.field_12586, class_2756.field_12607, true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.WEST_DOOR, list);
            }
        }

        {
            {
                List<class_2680> list = new ObjectArrayList<>();
                addSculkBlocks(false, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.SCULK_SENSOR_BLOCK, list);
            }
            {
                List<class_2680> list = new ObjectArrayList<>();
                addSculkBlocks(true, list);
                DefaultModelData.USABLE_STATES.put(BlockModelType.SCULK_SENSOR_BLOCK_WATERLOGGED, list);
            }
        }

        if (false && PolymerImpl.DEV_ENV) {
            PolymerImpl.LOGGER.info("===== Available States =====");
            for (var model : BlockModelType.values()) {
                PolymerImpl.LOGGER.info("{}: {}", model.name(), USABLE_STATES.get(model).size());

            }
        }
    }

    private static void addSculkBlocks(boolean waterlogged, List<class_2680> list) {
        for (class_5705 phase : class_5705.values()) {
            if (phase == class_5705.field_28122) continue;
            for (int i = 1; i <= 15; i++) {
                class_2680 defaultState = class_2246.field_28108.method_9564().method_11657(class_5703.field_28111, phase).method_11657(class_5703.field_28113, waterlogged);
                class_2680 from = defaultState.method_11657(class_5703.field_28112, i);
                list.add(from);
                DefaultModelData.SPECIAL_REMAPS.put(from, defaultState);
            }
        }

        class_2350[] facingDirs = new class_2350[]{
                class_2350.field_11043,
                class_2350.field_11034,
                class_2350.field_11035,
                class_2350.field_11039
        };

        for (class_2350 direction : facingDirs) {
            for (class_5705 phase : class_5705.values()) {
                if (phase == class_5705.field_28122) continue;
                for (int i = 1; i <= 15; i++) {
                    class_2680 defaultState = class_2246.field_43231.method_9564().method_11657(class_5703.field_28111, phase).method_11657(class_5703.field_28113, waterlogged).method_11657(class_8236.field_43235, direction);
                    class_2680 from = defaultState.method_11657(class_5703.field_28112, i);
                    list.add(from);
                    DefaultModelData.SPECIAL_REMAPS.put(from, defaultState);
                }
            }
        }
    }

    private static void addDoor(class_2350 direction, class_2750 doorHinge, class_2756 doubleBlockHalf, boolean open, List<class_2680> list) {
        list.add(addSingleDoor(class_2246.field_47040, class_2246.field_47044, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSingleDoor(class_2246.field_47043, class_2246.field_47047, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSingleDoor(class_2246.field_47041, class_2246.field_47045, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSingleDoor(class_2246.field_47042, class_2246.field_47046, direction, doorHinge, doubleBlockHalf, open));

        list.add(addSinglePoweredDoor(class_2246.field_10232, class_2246.field_10232, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_40291, class_2246.field_40291, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10352, class_2246.field_10352, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_42748, class_2246.field_42748, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_22102, class_2246.field_22102, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10403, class_2246.field_10403, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10627, class_2246.field_10627, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_37566, class_2246.field_37566, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10149, class_2246.field_10149, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_10521, class_2246.field_10521, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_22103, class_2246.field_22103, direction, doorHinge, doubleBlockHalf, open));

        list.add(addSinglePoweredDoor(class_2246.field_9973, class_2246.field_9973, direction, doorHinge, doubleBlockHalf, open));

        list.add(addSinglePoweredDoor(class_2246.field_47044, class_2246.field_47044, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_47047, class_2246.field_47047, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_47045, class_2246.field_47045, direction, doorHinge, doubleBlockHalf, open));
        list.add(addSinglePoweredDoor(class_2246.field_47046, class_2246.field_47046, direction, doorHinge, doubleBlockHalf, open));
    }

    private static class_2680 addSinglePoweredDoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2750 hinge, class_2756 half, boolean open) {
        class_2680 from = block.method_9564().method_11657(class_2323.field_10940, true).method_11657(class_2323.field_10945, open).method_11657(class_2323.field_10938, facing).method_11657(class_2323.field_10946, half).method_11657(class_2323.field_10941, hinge);
        class_2680 to = replacement.method_34725(from).method_11657(class_2323.field_10940, false);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSingleDoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2750 hinge, class_2756 half, boolean open) {
        class_2680 from = block.method_9564().method_11657(class_2323.field_10940, false).method_11657(class_2323.field_10945, open).method_11657(class_2323.field_10938, facing).method_11657(class_2323.field_10946, half).method_11657(class_2323.field_10941, hinge);
        class_2680 to = replacement.method_34725(from);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static void addTrapdoorHalf(class_2350 facing, class_2760 half, boolean waterlogged, BlockModelType modelType) {
        ObjectArrayList<class_2680> list = new ObjectArrayList<>();
        list.add(addSingleClosedTrapdoor(class_2246.field_47048, class_2246.field_47052, facing, half, waterlogged));
        list.add(addSingleClosedTrapdoor(class_2246.field_47049, class_2246.field_47053, facing, half, waterlogged));
        list.add(addSingleClosedTrapdoor(class_2246.field_47051, class_2246.field_47063, facing, half, waterlogged));
        list.add(addSingleClosedTrapdoor(class_2246.field_47050, class_2246.field_47062, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10608, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_40285, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10486, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_42740, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_22094, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10246, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10017, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_37555, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10137, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10323, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_22095, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10453, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47052, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47053, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47063, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47062, facing, half, waterlogged));

        DefaultModelData.USABLE_STATES.put(modelType, list);
    }

    private static void addTrapdoorDirection(class_2350 facing, class_2760 half, boolean waterlogged, BlockModelType modelType) {
        ObjectArrayList<class_2680> list = new ObjectArrayList<>();

        list.add(addSingleOpenTrapdoor(class_2246.field_47048, class_2246.field_47052, facing, half, waterlogged));
        list.add(addSingleOpenTrapdoor(class_2246.field_47049, class_2246.field_47053, facing, half, waterlogged));
        list.add(addSingleOpenTrapdoor(class_2246.field_47051, class_2246.field_47063, facing, half, waterlogged));
        list.add(addSingleOpenTrapdoor(class_2246.field_47050, class_2246.field_47062, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10608, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_40285, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10486, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_42740, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_22094, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10246, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10017, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_37555, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10137, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10323, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_22095, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_10453, facing, half, waterlogged));

        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47052, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47053, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47063, facing, half, waterlogged));
        list.add(addSinglePoweredOpenTrapdoor(class_2246.field_47062, facing, half, waterlogged));

        DefaultModelData.USABLE_STATES.put(modelType, list);
    }

    private static class_2680 addSingleOpenTrapdoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, true).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = replacement.method_34725(from);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSingleClosedTrapdoor(class_2248 block, class_2248 replacement, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, false).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = replacement.method_34725(from);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSinglePoweredOpenTrapdoor(class_2248 block, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, true).method_11657(class_2533.field_11629, true).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = from.method_11657(class_2533.field_11629, false);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static class_2680 addSinglePoweredClosedTrapdoor(class_2248 block, class_2350 facing, class_2760 half, boolean waterlogged) {
        class_2680 from = block.method_9564().method_11657(class_2533.field_11631, false).method_11657(class_2533.field_11629, true).method_11657(class_2533.field_11626, waterlogged).method_11657(class_2533.field_11177, facing).method_11657(class_2533.field_11625, half);
        class_2680 to = from.method_11657(class_2533.field_11629, false);
        DefaultModelData.SPECIAL_REMAPS.put(from, to);
        return from;
    }

    private static void addSlabs(class_2771 slabType, boolean waterlogged, BlockModelType modelType) {
        ObjectArrayList<class_2680> list = new ObjectArrayList<>();

        addSlab(slabType, waterlogged, class_2246.field_10119, class_2246.field_10298, list);
        addSlab(slabType, waterlogged, class_2246.field_27132, class_2246.field_27170, list);
        addSlab(slabType, waterlogged, class_2246.field_27131, class_2246.field_27169, list);
        addSlab(slabType, waterlogged, class_2246.field_27130, class_2246.field_27168, list);
        addSlab(slabType, waterlogged, class_2246.field_27129, class_2246.field_33410, list);

        DefaultModelData.USABLE_STATES.put(modelType, list);
    }

    private static void addSlab(class_2771 slabType, boolean waterlogged, class_2248 to, class_2248 from, ObjectArrayList<class_2680> list) {
        class_2680 state = from.method_9564().method_11657(class_2482.field_11502, waterlogged).method_11657(class_2482.field_11501, slabType);
        list.add(state);
        DefaultModelData.SPECIAL_REMAPS.put(state, to.method_34725(state));
    }

    private static void addDisarmedTripwire(boolean attached, BlockModelType modelType) {
        ObjectArrayList<class_2680> list = new ObjectArrayList<>();
        // generate all permutations of north, south, east, west, powered
        {
            var base = class_2246.field_10589.method_9564().method_11657(class_2538.field_11679, true);
            var booleans = new boolean[]{true, false};
            for (boolean north : booleans) {
                for (boolean south : booleans) {
                    for (boolean east : booleans) {
                        for (boolean west : booleans) {
                            for (boolean powered : booleans) {
                                class_2680 state = base
                                        .method_11657(class_2538.field_11683, attached)
                                        .method_11657(class_2538.field_11675, north)
                                        .method_11657(class_2538.field_11678, south)
                                        .method_11657(class_2538.field_11673, east)
                                        .method_11657(class_2538.field_11674, west)
                                        .method_11657(class_2538.field_11680, powered);
                                list.add(state);
                                DefaultModelData.SPECIAL_REMAPS.put(state, state.method_11657(class_2538.field_11679, false).method_11657(class_2538.field_11680, false));
                            }
                        }
                    }
                }
            }
        }

        DefaultModelData.USABLE_STATES.put(modelType, list);
    }

    private static void generateDefault(BlockModelType type, class_2248... blocks) {
        generateDefault(type, (b) -> true, blocks);
    }

    private static void generateDefault(BlockModelType type, Predicate<class_2680> shouldInclude, class_2248... blocks) {
        var list = new ArrayList<class_2680>();

        for (var block : blocks) {
            var id = class_7923.field_41175.method_10221(block);
            var model = new PolymerBlockModel[]{PolymerBlockModel.of(class_2960.method_60654(id.method_12836() + ":block/" + id.method_12832()))};
            for (var state : block.method_9595().method_11662()) {
                MODELS.put(state, model);
                if (shouldInclude.test(state)) {
                    list.add(state);
                }
            }

            if (block instanceof class_2397) {
                list.remove(block.method_9564().method_11657(class_2397.field_11200, true));
                list.remove(block.method_9564().method_11657(class_2397.field_11200, true).method_11657(class_2397.field_38227, true));
            } else {
                list.remove(block.method_9564());
            }
        }

        USABLE_STATES.put(type, list);
    }
}
