package eu.pb4.polymer.blocks.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PolymerBlocksInternal {
    public static Map<class_2680, PolymerBlockModel[]> modelMap = Collections.emptyMap();



    public static JsonArray createJsonElement(PolymerBlockModel[] models) {
        var array = new JsonArray();

        for (var model : models) {
            var modelObj = new JsonObject();

            modelObj.addProperty("model", model.model().toString());
            modelObj.addProperty("x", model.x());
            modelObj.addProperty("y", model.y());
            modelObj.addProperty("uvlock", model.uvLock());
            modelObj.addProperty("weight", model.weight());

            array.add(modelObj);
        }

        return array;
    }

    public static String generateStateName(class_2680 state) {
        var stringBuilder = new StringBuilder();

        var iterator = state.method_11656().entrySet().iterator();

        while (iterator.hasNext()) {
            var entry = iterator.next();
            stringBuilder.append((entry.getKey()).method_11899()).append("=").append(((class_2769) entry.getKey()).method_11901(entry.getValue()));

            if (iterator.hasNext()) {
                stringBuilder.append(",");
            }
        }

        return stringBuilder.toString();
    }
}
