/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.blocks.api;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.pb4.polymer.blocks.api.BlockModelType;
import eu.pb4.polymer.blocks.api.PolymerBlockModel;
import eu.pb4.polymer.blocks.api.PolymerBlockResourceUtils;
import eu.pb4.polymer.blocks.impl.BlockExtBlockMapper;
import eu.pb4.polymer.blocks.impl.DefaultModelData;
import eu.pb4.polymer.blocks.impl.PolymerBlocksInternal;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.core.api.block.BlockMapper;
import eu.pb4.polymer.core.api.block.PolymerBlockUtils;
import eu.pb4.polymer.core.impl.PolymerImpl;
import eu.pb4.polymer.resourcepack.api.ResourcePackCreator;
import eu.pb4.polymer.resourcepack.impl.generation.DefaultRPBuilder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3737;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class BlockResourceCreator {
    private static final PolymerBlockModel EMPTY = PolymerBlockModel.of(class_2960.method_60655((String)"polymer", (String)"block/empty"));
    private final Map<BlockModelType, List<class_2680>> states;
    private final Set<class_2248> hasRequested = Collections.newSetFromMap(new IdentityHashMap());
    final Map<class_2680, PolymerBlockModel[]> models;
    private final ResourcePackCreator creator;
    private final Runnable onRegister;
    private final BlockExtBlockMapper blockMapper;
    private final EnumMap<BlockModelType, class_2680> emptyBlocks = new EnumMap(BlockModelType.class);
    private boolean registered = false;
    private boolean registeredEmpty = false;

    public static BlockResourceCreator of(ResourcePackCreator creator) {
        if (CompatStatus.POLYMC) {
            PolymerImpl.LOGGER.warn("Polymer Blocks non-global module might not work correctly with PolyMC! Be warned!");
        }
        return new BlockResourceCreator(creator, new BlockExtBlockMapper(BlockMapper.createDefault()), () -> {});
    }

    BlockResourceCreator(ResourcePackCreator creator, BlockExtBlockMapper blockMapper, Runnable onRegister) {
        this.states = new EnumMap<BlockModelType, List<class_2680>>(DefaultModelData.USABLE_STATES);
        this.models = new IdentityHashMap<class_2680, PolymerBlockModel[]>(DefaultModelData.MODELS);
        this.creator = creator;
        this.blockMapper = blockMapper;
        this.onRegister = onRegister;
    }

    public BlockMapper getBlockMapper() {
        return this.blockMapper;
    }

    private void registerEvent() {
        if (!this.registered) {
            PolymerBlockUtils.requireStrictBlockUpdates();
            this.creator.creationEvent.register(b -> {
                if (b instanceof DefaultRPBuilder) {
                    DefaultRPBuilder defaultRPBuilder = (DefaultRPBuilder)b;
                    defaultRPBuilder.buildEvent.register(c -> this.generateResources(defaultRPBuilder, (List<String>)c));
                }
            });
            this.onRegister.run();
            this.registered = true;
        }
    }

    @Nullable
    public class_2680 requestEmpty(BlockModelType type) {
        class_2680 x = this.emptyBlocks.get((Object)type);
        if (x != null) {
            return x;
        }
        x = this.requestBlock(type, EMPTY);
        this.emptyBlocks.put(type, x);
        if (!this.registeredEmpty) {
            this.registeredEmpty = true;
            this.creator.addAssetSource("polymer-blocks");
        }
        return x;
    }

    @Nullable
    public class_2680 requestBlock(BlockModelType type, PolymerBlockModel ... model) {
        List<class_2680> states = this.states.get((Object)type);
        if (!states.isEmpty()) {
            this.registerEvent();
            class_2680 state = states.removeFirst();
            this.models.put(state, model);
            this.hasRequested.add(state.method_26204());
            if (state.method_26204() instanceof class_3737) {
                this.blockMapper.stateMap.put(state, DefaultModelData.SPECIAL_REMAPS.getOrDefault(state, (class_2680)(state.method_26204() instanceof class_2397 ? (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)) : state.method_26204().method_9564()).method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)state.method_11654((class_2769)class_2741.field_12508)))));
            } else {
                this.blockMapper.stateMap.put(state, DefaultModelData.SPECIAL_REMAPS.getOrDefault(state, state.method_26204() instanceof class_2397 ? (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2397.field_11200, (Comparable)Boolean.valueOf(true)) : state.method_26204().method_9564()));
            }
            return state;
        }
        return null;
    }

    public int getBlocksLeft(BlockModelType type) {
        return this.states.get((Object)type).size();
    }

    private void generateResources(DefaultRPBuilder builder, List<String> credits) {
        if (CompatStatus.POLYMC && this == PolymerBlockResourceUtils.CREATOR) {
            return;
        }
        HashMap<String, HashMap> map = new HashMap<String, HashMap>();
        for (Map.Entry<class_2680, PolymerBlockModel[]> entry : this.models.entrySet()) {
            if (!this.hasRequested.contains(entry.getKey().method_26204())) continue;
            class_2680 state = entry.getKey();
            PolymerBlockModel[] models = entry.getValue();
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            String stateName = PolymerBlocksInternal.generateStateName(state);
            JsonArray array = PolymerBlocksInternal.createJsonElement(models);
            map.computeIfAbsent("assets/" + id.method_12836() + "/blockstates/" + id.method_12832() + ".json", s -> new HashMap()).put(stateName, array);
        }
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            try {
                JsonObject modelObject = new JsonObject();
                JsonObject variants = new JsonObject();
                ArrayList values = new ArrayList(((HashMap)entry.getValue()).entrySet());
                values.sort(Map.Entry.comparingByKey());
                for (Map.Entry entries : values) {
                    variants.add((String)entries.getKey(), (JsonElement)entries.getValue());
                }
                modelObject.add("variants", (JsonElement)variants);
                builder.addData((String)entry.getKey(), DefaultRPBuilder.GSON.toJson((JsonElement)modelObject).getBytes(StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                PolymerImpl.LOGGER.warn("Exception occurred while building block model!", (Throwable)e);
            }
        }
    }
}

