package eu.pb4.polymer.common.impl;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.polymer.common.impl.client.ClientUtils;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import it.unimi.dsi.fastutil.Hash;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

import javax.imageio.ImageIO;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class CommonImplUtils {
    public static final Hash.Strategy<Object> IDENTITY_HASH = new Hash.Strategy<Object>() {
        @Override
        public int hashCode(Object o) {
            return System.identityHashCode(o);
        }

        @Override
        public boolean equals(Object a, Object b) {
            return a == b;
        }
    };
    public static final class_2561[] ICON;
    public static boolean disableResourcePackCheck;

    static {
        final String chr = "█";
        class_2561[] iconArray;
        try {
            var source = ImageIO.read(CommonImpl.getJarPath("assets/icon_ingame.png").toUri().toURL());
            var icon = new ArrayList<class_5250>();

            for (int y = 0; y < source.getHeight(); y++) {
                var base = class_2561.method_43473();
                int line = 0;
                int color = source.getRGB(0, y) & 0xFFFFFF;
                for (int x = 0; x < source.getWidth(); x++) {
                    int colorPixel = source.getRGB(x, y) & 0xFFFFFF;

                    if (color == colorPixel) {
                        line++;
                    } else {
                        base.method_10852(class_2561.method_43470(chr.repeat(line)).method_10862(class_2583.field_24360.method_36139(color).method_65302(color | 0xFF000000)));
                        color = colorPixel;
                        line = 1;
                    }
                }

                base.method_10852(class_2561.method_43470(chr.repeat(line)).method_10862(class_2583.field_24360.method_36139(color).method_65302(color | 0xFF000000)));
                icon.add(base);
            }

            iconArray = icon.toArray(new class_2561[0]);
        } catch (Throwable e) {
            e.printStackTrace();
            iconArray = new class_2561[0];
        }
        ICON = iconArray;
    }

    public static void registerCommands(Consumer<LiteralArgumentBuilder<class_2168>> consumer) {
        CommonCommands.COMMANDS.add((a, b) -> consumer.accept(a));
    }

    public static void registerCommands(BiConsumer<LiteralArgumentBuilder<class_2168>, class_7157> consumer) {
        CommonCommands.COMMANDS.add(consumer);
    }

    public static void registerDevCommands(Consumer<LiteralArgumentBuilder<class_2168>> consumer) {
        CommonCommands.COMMANDS_DEV.add((a, b) -> consumer.accept(a));
    }

    public static void registerDevCommands(BiConsumer<LiteralArgumentBuilder<class_2168>, class_7157> consumer) {
        CommonCommands.COMMANDS_DEV.add(consumer);
    }

    public static Predicate<class_2168> permission(String path, int operatorLevel) {
        if (CompatStatus.FABRIC_PERMISSION_API_V0) {
            return Permissions.require("polymer." + path, operatorLevel);
        } else {
            return source -> source.method_9259(operatorLevel);
        }
    }

    public static boolean permissionCheck(class_3222 player, String path, int operatorLevel) {
        if (CompatStatus.FABRIC_PERMISSION_API_V0) {
            return Permissions.check(player, "polymer." + path, operatorLevel);
        } else {
            return player.method_64475(operatorLevel);
        }
    }

    public static <T> T createUnsafe(Class<T> tClass) {
        try {
            return (T) UnsafeAccess.UNSAFE.allocateInstance(tClass);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String shortId(class_2960 key) {
        return key.method_12836().equals(class_2960.field_33381) ? key.method_12832() : key.toString();
    }

    public static class_2960 id(String s) {
        return class_2960.method_60655("polymer", s);
    }

    public static boolean isMainPlayer(class_3222 player) {
        if (CommonImpl.IS_CLIENT) {
            if (ClientUtils.isSingleplayer()) {
                return player == ClientUtils.getPlayer();
            }
        }
        return false;
    }
}
