package eu.pb4.polymer.common.impl;

import com.mojang.serialization.Codec;
import java.util.function.Consumer;
import net.minecraft.class_5699;

public final class LazyIdMapper<A, B> extends class_5699.class_10388<A, B> {
    private Consumer<class_5699.class_10388<A,B>> initializer;

    public LazyIdMapper(Consumer<class_5699.class_10388<A, B>> initializer) {
        this.initializer = initializer;
    }

    @Override
    public Codec<B> method_65323(Codec<A> idCodec) {
        if (this.initializer != null) {
            var init = this.initializer;
            this.initializer = null;
            init.accept(this);
        }
        return super.method_65323(idCodec);
    }

    @Override
    public class_5699.class_10388<A, B> method_65325(A id, B value) {
        if (this.initializer != null) {
            var init = this.initializer;
            this.initializer = null;
            init.accept(this);
        }
        return super.method_65325(id, value);
    }
}
