/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.common.api;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.common.api.ScopedOverride;
import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonClientConnectionExt;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.common.impl.FakeWorld;
import eu.pb4.polymer.common.impl.LogicOverride;
import eu.pb4.polymer.common.impl.client.ClientUtils;
import eu.pb4.polymer.common.impl.compat.FloodGateUtils;
import eu.pb4.polymer.common.impl.compat.ViaVersionUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_155;
import net.minecraft.class_1937;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_8609;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;
import xyz.nucleoid.packettweaker.impl.MutableContext;

public final class PolymerCommonUtils {
    public static final SimpleEvent<ResourcePackChangeCallback> ON_RESOURCE_PACK_STATUS_CHANGE = new SimpleEvent();
    private static final ThreadLocal<LogicOverride> FORCE_NETWORKING = ThreadLocal.withInitial(() -> LogicOverride.DEFAULT);
    private static final String SAFE_CLIENT_SHA1 = "ce92fd8d1b2460c41ceda07ae7b3fe863a80d045";
    private static final String SAFE_CLIENT_URL = "https://piston-data.mojang.com/v1/objects/ce92fd8d1b2460c41ceda07ae7b3fe863a80d045/client.jar";
    private static Path cachedClientPath;
    private static Path cachedClientJarRoot;

    private PolymerCommonUtils() {
    }

    @Nullable
    public static Path getClientJarRoot() {
        Path source;
        if (cachedClientJarRoot != null) {
            return cachedClientJarRoot;
        }
        if (CommonImpl.IS_CLIENT) {
            ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get();
            for (Path x : container.getRootPaths()) {
                if (!Files.exists(x.resolve("assets"), new LinkOption[0])) continue;
                cachedClientJarRoot = x;
                return x;
            }
        }
        if ((source = PolymerCommonUtils.getClientJar()) == null) {
            return null;
        }
        try {
            FileSystem fs = FileSystems.newFileSystem(source);
            for (Path x : fs.getRootDirectories()) {
                if (!Files.exists(x.resolve("assets"), new LinkOption[0])) continue;
                cachedClientJarRoot = x;
                return x;
            }
            fs.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path getClientJar() {
        if (cachedClientPath != null) {
            return cachedClientPath;
        }
        try {
            Path clientJarPath;
            URI clientFile;
            Path clientJarPath2;
            if (CommonImpl.IS_CLIENT && Files.exists(clientJarPath2 = Path.of(clientFile = MinecraftServer.class.getProtectionDomain().getCodeSource().getLocation().toURI()), new LinkOption[0])) {
                try (FileSystem fs = FileSystems.newFileSystem(clientJarPath2);){
                    if (Files.exists(fs.getPath("/", new String[0]), new LinkOption[0])) {
                        Path path = cachedClientPath = clientJarPath2;
                        return path;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (!Files.exists(clientJarPath = CommonImpl.getGameDir().resolve("polymer/cached_client_jars/ce92fd8d1b2460c41ceda07ae7b3fe863a80d045.jar"), new LinkOption[0])) {
                Files.createDirectories(clientJarPath.getParent(), new FileAttribute[0]);
                CommonImpl.LOGGER.info("Downloading vanilla client jar...");
                URL url = new URL(SAFE_CLIENT_URL);
                URLConnection connection = url.openConnection();
                InputStream is = connection.getInputStream();
                Files.copy(is, clientJarPath, new CopyOption[0]);
            }
            cachedClientPath = clientJarPath;
            return clientJarPath;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't retrieve client jar!", (Throwable)e);
            return null;
        }
    }

    public static void executeWithNetworkingLogic(Runnable runnable) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.TRUE);
        runnable.run();
        FORCE_NETWORKING.set(val);
    }

    public static void executeWithNetworkingLogic(class_2547 listener, Runnable runnable) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.TRUE);
        PacketContext.runWithContext((class_2547)listener, (Runnable)runnable);
        FORCE_NETWORKING.set(val);
    }

    public static void executeWithoutNetworkingLogic(Runnable runnable) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.FALSE);
        try {
            PacketContext.runWithContext(null, (Runnable)runnable);
        }
        finally {
            FORCE_NETWORKING.set(val);
        }
    }

    public static <T> T executeWithNetworkingLogic(Supplier<T> supplier) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.TRUE);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            FORCE_NETWORKING.set(val);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithNetworkingLogic(class_2547 listener, Supplier<T> supplier) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.TRUE);
        try {
            Object object = PacketContext.supplyWithContext((class_2547)listener, supplier);
            return (T)object;
        }
        finally {
            FORCE_NETWORKING.set(val);
        }
    }

    public static <T> T executeWithoutNetworkingLogic(Supplier<T> supplier) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.FALSE);
        try {
            Object object = PacketContext.supplyWithContext(null, supplier);
            return (T)object;
        }
        finally {
            FORCE_NETWORKING.set(val);
        }
    }

    public static ScopedOverride executeWithNetworkingLogic() {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.TRUE);
        return () -> FORCE_NETWORKING.set(val);
    }

    public static ScopedOverride executeWithNetworkingLogic(class_2547 listener) {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.TRUE);
        class_2535 connection = MutableContext.get().getClientConnection();
        class_2596 packet = MutableContext.get().getEncodedPacket();
        MutableContext.get().set(listener, null);
        return () -> {
            MutableContext.get().set(connection, packet);
            FORCE_NETWORKING.set(val);
        };
    }

    public static ScopedOverride executeWithoutNetworkingLogic() {
        LogicOverride val = FORCE_NETWORKING.get();
        FORCE_NETWORKING.set(LogicOverride.FALSE);
        class_2535 connection = MutableContext.get().getClientConnection();
        class_2596 packet = MutableContext.get().getEncodedPacket();
        MutableContext.get().clear();
        return () -> {
            MutableContext.get().set(connection, packet);
            FORCE_NETWORKING.set(val);
        };
    }

    public static class_1937 getFakeWorld() {
        return FakeWorld.INSTANCE;
    }

    public static boolean isNetworkingThread() {
        return FORCE_NETWORKING.get().value(Thread.currentThread().getName().startsWith("Netty"));
    }

    public static boolean isServerNetworkingThread() {
        return FORCE_NETWORKING.get().value(Thread.currentThread().getName().startsWith("Netty") && Thread.currentThread().getName().contains("Server"));
    }

    public static boolean isClientNetworkingThread() {
        return CommonImpl.IS_CLIENT && FORCE_NETWORKING.get().value(Thread.currentThread().getName().startsWith("Netty") && Thread.currentThread().getName().contains("Client"));
    }

    public static boolean isBedrockPlayer(class_3222 player) {
        if (CompatStatus.FLOODGATE) {
            return FloodGateUtils.isPlayerBroken(player);
        }
        return false;
    }

    public static boolean isBedrockPlayer(GameProfile profile) {
        if (CompatStatus.FLOODGATE) {
            return FloodGateUtils.isPlayerBroken(profile.id());
        }
        return false;
    }

    public static int getPlayerGameProtocol(class_3222 player) {
        return PolymerCommonUtils.getPlayerGameProtocol(player.method_7334());
    }

    public static int getPlayerGameProtocol(GameProfile profile) {
        if (CompatStatus.VIAVERSION) {
            return ViaVersionUtils.getProtocol(profile.id());
        }
        return class_155.method_16673().comp_4027();
    }

    public static boolean hasResourcePack(@Nullable class_3222 player, UUID uuid) {
        return CommonImpl.FORCE_RESOURCEPACK_ENABLED_STATE || player != null && player.field_13987 != null && ((CommonClientConnectionExt)((CommonNetworkHandlerExt)player.field_13987).polymerCommon$getConnection()).polymerCommon$hasResourcePack(uuid) || CommonImpl.IS_CLIENT && ClientUtils.isResourcePackLoaded();
    }

    public static boolean hasResourcePack(class_8609 handler, UUID uuid) {
        return CommonImpl.FORCE_RESOURCEPACK_ENABLED_STATE || ((CommonClientConnectionExt)((CommonNetworkHandlerExt)handler).polymerCommon$getConnection()).polymerCommon$hasResourcePack(uuid) || CommonImpl.IS_CLIENT && ClientUtils.isResourcePackLoaded();
    }

    public static boolean hasResourcePack(class_2535 connection, UUID uuid) {
        return CommonImpl.FORCE_RESOURCEPACK_ENABLED_STATE || ((CommonClientConnectionExt)connection).polymerCommon$hasResourcePack(uuid) || CommonImpl.IS_CLIENT && ClientUtils.isResourcePackLoaded();
    }

    public static boolean hasResourcePack(PacketContext context, UUID uuid) {
        return CommonImpl.FORCE_RESOURCEPACK_ENABLED_STATE || context.getClientConnection() != null && PolymerCommonUtils.hasResourcePack(context.getClientConnection(), uuid);
    }

    public static boolean isServerBound() {
        if (CommonImpl.IS_CLIENT) {
            return ClientUtils.isSingleplayer();
        }
        return true;
    }

    public static void setHasResourcePack(class_3222 player, UUID uuid, boolean status) {
        ((CommonClientConnectionExt)((CommonNetworkHandlerExt)player.field_13987).polymerCommon$getConnection()).polymerCommon$setResourcePack(uuid, status);
    }

    public static void setHasResourcePack(class_2535 player, UUID uuid, boolean status) {
        ((CommonClientConnectionExt)player).polymerCommon$setResourcePack(uuid, status);
    }

    public static <T> T createUnsafe(Class<T> clazz) {
        return CommonImplUtils.createUnsafe(clazz);
    }

    public static boolean isServerNetworkingThreadWithContext() {
        return PolymerCommonUtils.isServerNetworkingThread() && PacketContext.get().getClientConnection() != null;
    }

    public static interface ResourcePackChangeCallback {
        public void onResourcePackChange(class_8609 var1, UUID var2, boolean var3, boolean var4);
    }
}

