/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.common.impl;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.BaseMapCodec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;

public record SortedMapCodec<K, V>(Codec<K> keyCodec, Codec<V> elementCodec, Comparator<Map.Entry<K, V>> comparator) implements Codec<Map<K, V>>,
BaseMapCodec<K, V>
{
    public static <K extends Comparable<K>, V> SortedMapCodec<K, V> of(Codec<K> keyCodec, Codec<V> elementCodec) {
        return new SortedMapCodec<K, V>(keyCodec, elementCodec, Map.Entry.comparingByKey());
    }

    public static <K, V> SortedMapCodec<K, V> of(Codec<K> keyCodec, Codec<V> elementCodec, Comparator<K> comparator) {
        return new SortedMapCodec<K, V>(keyCodec, elementCodec, Map.Entry.comparingByKey(comparator));
    }

    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).setLifecycle(Lifecycle.stable()).flatMap(map -> this.decode(ops, map)).map(r -> Pair.of((Object)r, (Object)input));
    }

    public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.encode(input, ops, ops.mapBuilder()).build(prefix);
    }

    public <T> RecordBuilder<T> encode(Map<K, V> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        ArrayList<Map.Entry<K, V>> entries = new ArrayList<Map.Entry<K, V>>(input.entrySet());
        entries.sort(this.comparator);
        for (Map.Entry<K, V> entry : entries) {
            prefix.add(this.keyCodec.encodeStart(ops, entry.getKey()), this.elementCodec.encodeStart(ops, entry.getValue()));
        }
        return prefix;
    }

    @Override
    public String toString() {
        return "SortedMapCodec[" + String.valueOf(this.keyCodec) + " -> " + String.valueOf(this.elementCodec) + "]";
    }
}

