/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.common.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.polymer.common.impl.CommonConfig;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.common.impl.MixinOverrideConfig;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonImpl {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Polymer");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Gson GSON_PRETTY = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public static final int CORE_COMMAND_MINIMAL_OP;
    public static final boolean DEVELOPER_MODE;
    public static final boolean MINIMAL_ABOUT;
    public static final String DESCRIPTION = "Library for creating better server side content!";
    public static final FabricLoader LOADER;
    public static final boolean DEV_ENV;
    public static final boolean IS_CLIENT;
    public static final boolean LOG_MORE_ERRORS;
    public static final boolean ENABLE_TEMPLATE_ENTITY_WARNINGS;
    public static final boolean FORCE_RESOURCEPACK_ENABLED_STATE;
    private static final ModContainer CONTAINER;
    public static final List<String> CONTRIBUTORS;
    public static final String VERSION;
    public static final String GITHUB_URL;
    public static final Map<String, DisabledMixinReason> DISABLED_MIXINS;
    public static final Set<Map.Entry<String, Class<?>>> KNOWN_CONFIGS;
    private static boolean devWarn;

    public static DisabledMixinReason getDisabledMixin(String source, String mixin) {
        return DISABLED_MIXINS.get(source + ":" + mixin);
    }

    public static void addContributor(Person person) {
        if (!CONTRIBUTORS.contains(person.getName())) {
            CONTRIBUTORS.add(person.getName());
        }
    }

    public static boolean isModLoaded(String modId) {
        return LOADER.isModLoaded(modId);
    }

    public static Path configDir() {
        return LOADER.getConfigDir().resolve("polymer");
    }

    public static void registerConfig(String name, Class<?> clazz) {
        KNOWN_CONFIGS.add(Map.entry(name, clazz));
    }

    public static <T> T loadAndRegisterConfig(String name, Class<T> clazz) {
        CommonImpl.registerConfig(name, clazz);
        return CommonImpl.loadConfig(name, clazz);
    }

    public static <T> T loadConfig(String name, Class<T> clazz) {
        try {
            String json;
            Object obj;
            Path path;
            Path folder = CommonImpl.configDir();
            if (!Files.isDirectory(folder, new LinkOption[0])) {
                if (Files.exists(folder, new LinkOption[0])) {
                    Files.deleteIfExists(folder);
                }
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            if ((path = folder.resolve(name + ".json")).toFile().isFile() && (obj = GSON.fromJson(json = IOUtils.toString((Reader)new InputStreamReader((InputStream)new FileInputStream(path.toFile()), StandardCharsets.UTF_8)), clazz)) != null) {
                CommonImpl.saveConfig(name, obj);
                return (T)obj;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't load config! " + clazz.toString());
            LOGGER.warn(e.toString());
        }
        try {
            T obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            CommonImpl.saveConfig(name, obj);
            return obj;
        }
        catch (Exception e) {
            LOGGER.error("Invalid config class! " + clazz.toString());
            throw new RuntimeException(e);
        }
    }

    public static void saveConfig(String name, Object obj) {
        try {
            Path folder = CommonImpl.configDir();
            if (!Files.isDirectory(folder, new LinkOption[0])) {
                if (Files.exists(folder, new LinkOption[0])) {
                    Files.deleteIfExists(folder);
                }
                Files.createDirectories(folder, new FileAttribute[0]);
            }
            Path path = folder.resolve(name + ".json");
            Files.writeString(path, (CharSequence)GSON_PRETTY.toJson(obj), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            LOGGER.warn("Couldn't save config! " + String.valueOf(obj.getClass()));
        }
    }

    public static Path getJarPath(String path) {
        return CONTAINER.getPath(path);
    }

    public static Path getGameDir() {
        return LOADER.getGameDir();
    }

    public static boolean shouldApplyMixin(String source, String mixinClassName) {
        DisabledMixinReason disabledReason = CommonImpl.getDisabledMixin(source, mixinClassName);
        if (disabledReason != null) {
            LOGGER.warn("Mixin '" + mixinClassName + "' from '" + source + "' was disabled by " + disabledReason.source() + ". Reason: " + disabledReason.reason() + ". This might cause issues and isn't generally supported!");
            if (DEV_ENV && !devWarn) {
                devWarn = true;
                LOGGER.error("Ok... I see you are disabling my mixins. It's generally not good idea to do that, since most likely this will break polymer. Only do it if you make sure everything will work fine (for example by replicating logic in your own mod). If you need to do more things, it might be better to just ask me to add api for that. I'm open for these if they allow better usage/integration with polymer... Make a github issue or ask on discord!");
            }
            return false;
        }
        String name = mixinClassName;
        if ((name = name.replace("client.", "")).startsWith("compat.")) {
            String type;
            String[] tmp = name.split("\\.");
            return switch (type = tmp[tmp.length - 1].split("_")[0]) {
                case "fabricSync" -> CompatStatus.FABRIC_SYNC;
                case "fabricSH" -> CompatStatus.FABRIC_SCREEN_HANDLER;
                case "fabricItemGroup" -> CompatStatus.FABRIC_ITEM_GROUP;
                case "fabricNetworking" -> CompatStatus.FABRIC_NETWORKING;
                case "fabricItem" -> CompatStatus.FABRIC_ITEM;
                case "polymc" -> CompatStatus.POLYMC;
                case "wthit" -> CompatStatus.WTHIT;
                case "rei" -> CompatStatus.REI;
                case "emi" -> CompatStatus.EMI;
                case "lithium" -> CompatStatus.LITHIUM;
                case "jei" -> CompatStatus.JEI;
                case "ip" -> CompatStatus.IMMERSIVE_PORTALS;
                case "quiltReg" -> CompatStatus.QUILT_REGISTRY;
                default -> true;
            };
        }
        if (name.startsWith("debug.")) {
            return DEVELOPER_MODE;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    static {
        LOADER = FabricLoader.getInstance();
        DEV_ENV = LOADER.isDevelopmentEnvironment();
        IS_CLIENT = LOADER.getEnvironmentType() == EnvType.CLIENT;
        CONTAINER = (ModContainer)FabricLoader.getInstance().getModContainer("polymer-common").get();
        CONTRIBUTORS = new ArrayList<String>();
        VERSION = CONTAINER.getMetadata().getVersion().getFriendlyString().split("\\+")[0];
        GITHUB_URL = CONTAINER.getMetadata().getContact().get("sources").orElse("https://pb4.eu");
        DISABLED_MIXINS = new HashMap<String, DisabledMixinReason>();
        KNOWN_CONFIGS = new LinkedHashSet();
        new CompatStatus();
        if (CompatStatus.FORGE_CONNECTOR) {
            LOGGER.warn("==================================================================================");
            LOGGER.warn("Polymer (" + VERSION + ") does not support Connector/Forge!");
            LOGGER.warn("It will likely not work correctly if at all!");
            LOGGER.warn("=================================================================================");
        }
        CommonConfig config = CommonImpl.loadAndRegisterConfig("common", CommonConfig.class);
        CORE_COMMAND_MINIMAL_OP = config.coreCommandOperatorLevel;
        DEVELOPER_MODE = config.enableDevTools || DEV_ENV;
        MINIMAL_ABOUT = config.minimalisticAbout;
        LOG_MORE_ERRORS = config.logAllExceptions || DEV_ENV;
        ENABLE_TEMPLATE_ENTITY_WARNINGS = config.enableTemplateEntityWarnings;
        FORCE_RESOURCEPACK_ENABLED_STATE = config.forceResourcePackEnabled;
        CONTAINER.getMetadata().getAuthors().forEach(CommonImpl::addContributor);
        CONTAINER.getMetadata().getContributors().forEach(CommonImpl::addContributor);
        if (CommonImpl.configDir().resolve("mixins.json").toFile().isFile()) {
            for (String string : CommonImpl.loadConfig((String)"mixins", MixinOverrideConfig.class).disabledMixins) {
                void var2_2;
                if (!string.contains(":")) {
                    String string2 = "polymer-core:" + string;
                }
                DISABLED_MIXINS.put((String)var2_2, new DisabledMixinReason("Config file (polymer/mixins.json)", "User/config specified, unknown reason"));
            }
        }
        for (ModContainer modContainer : LOADER.getAllMods()) {
            Object key;
            ModMetadata meta = modContainer.getMetadata();
            CustomValue customValue = meta.getCustomValue("polymer:disable_mixin");
            if (customValue instanceof CustomValue.CvArray) {
                CustomValue.CvArray cvArray = (CustomValue.CvArray)customValue;
                for (Object value : cvArray) {
                    key = value.getAsString();
                    if (!((String)key).contains(":")) {
                        key = "polymer-core:" + (String)key;
                    }
                    DISABLED_MIXINS.put((String)key, new DisabledMixinReason(meta.getName() + " (" + meta.getId() + ")", "Unknown reason! I hope author knew what they were doing.."));
                }
                continue;
            }
            if (!(customValue instanceof CustomValue.CvObject)) continue;
            CustomValue.CvObject cvObject = (CustomValue.CvObject)customValue;
            for (Object value : cvObject) {
                key = (String)value.getKey();
                if (!((String)key).contains(":")) {
                    key = "polymer-core:" + (String)key;
                }
                DISABLED_MIXINS.put((String)key, new DisabledMixinReason(meta.getName() + " (" + meta.getId() + ")", ((CustomValue)value.getValue()).getAsString()));
            }
        }
    }

    public record DisabledMixinReason(String source, String reason) {
    }
}

