package eu.pb4.polymer.common.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import eu.pb4.polymer.common.api.PolymerCommonUtils;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

import static net.minecraft.class_2170.method_9247;

@SuppressWarnings("ResultOfMethodCallIgnored")
@ApiStatus.Internal
public class CommonCommands {
    public static final List<BiConsumer<LiteralArgumentBuilder<class_2168>, class_7157>> COMMANDS_DEV = new ArrayList<>();
    public static final List<BiConsumer<LiteralArgumentBuilder<class_2168>, class_7157>> COMMANDS = new ArrayList<>();
    private static final class_2561[] ABOUT_PLAYER;
    private static final class_2561[] ABOUT_COLORLESS;

    static {
        var about = new ArrayList<class_2561>();
        var extraData = class_2561.method_43473();
        try {
            extraData.method_10852(class_2561.method_43470("[")
                    .method_10852(class_2561.method_43470("Contributors")
                            .method_10862(class_2583.field_24360.method_10977(class_124.field_1075)
                                    .method_10949(new class_2568(class_2568.class_5247.field_24342,
                                            class_2561.method_43470(String.join("\n", CommonImpl.CONTRIBUTORS))
                                    ))
                            ))
                    .method_27693("] ")
            ).method_10852(class_2561.method_43470("[")
                    .method_10852(class_2561.method_43470("GitHub")
                            .method_10862(class_2583.field_24360.method_10977(class_124.field_1078).method_30938(true)
                                    .method_10958(new class_2558(class_2558.class_2559.field_11749, CommonImpl.GITHUB_URL))
                                    .method_10949(new class_2568(class_2568.class_5247.field_24342,
                                            class_2561.method_43470(CommonImpl.GITHUB_URL)
                                    ))
                            ))
                    .method_27693("]")).method_10862(class_2583.field_24360.method_10977(class_124.field_1063));

            about.add(class_2561.method_43473()
                    .method_10852(class_2561.method_43470("Polymer ").method_10862(class_2583.field_24360.method_36139(0xb4ff90).method_10982(true)))
                    .method_10852(class_2561.method_43470(CommonImpl.VERSION).method_10862(class_2583.field_24360.method_10977(class_124.field_1068))));

            about.add(class_2561.method_43470("» " + CommonImpl.DESCRIPTION).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));

            about.add(extraData);
        } catch (Throwable e) {
            e.printStackTrace();
        }

        ABOUT_COLORLESS = about.toArray(new class_2561[0]);

        if (CommonImpl.MINIMAL_ABOUT || CommonImplUtils.ICON.length == 0) {
            ABOUT_PLAYER = ABOUT_COLORLESS;
        } else {
            var output = new ArrayList<class_2561>();
            about.clear();
            try {
                about.add(class_2561.method_43470("Polymer").method_10862(class_2583.field_24360.method_36139(0xb4ff90).method_10982(true).method_10958(new class_2558(class_2558.class_2559.field_11749, CommonImpl.GITHUB_URL))));
                about.add(class_2561.method_43470("Version: ").method_10862(class_2583.field_24360.method_36139(0xf7e1a7))
                        .method_10852(class_2561.method_43470(CommonImpl.VERSION).method_10862(class_2583.field_24360.method_10977(class_124.field_1068))));

                about.add(extraData);
                about.add(class_2561.method_43473());

                var desc = new ArrayList<>(List.of(CommonImpl.DESCRIPTION.split(" ")));

                if (desc.size() > 0) {
                    StringBuilder descPart = new StringBuilder();
                    while (!desc.isEmpty()) {
                        (descPart.isEmpty() ? descPart : descPart.append(" ")).append(desc.remove(0));

                        if (descPart.length() > 16) {
                            about.add(class_2561.method_43470(descPart.toString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                            descPart = new StringBuilder();
                        }
                    }

                    if (descPart.length() > 0) {
                        about.add(class_2561.method_43470(descPart.toString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                    }
                }

                if (CommonImplUtils.ICON.length > about.size() + 2) {
                    int a = 0;
                    for (int i = 0; i < CommonImplUtils.ICON.length; i++) {
                        if (i == (CommonImplUtils.ICON.length - about.size() - 1) / 2 + a && a < about.size()) {
                            output.add(CommonImplUtils.ICON[i].method_27661().method_27693("  ").method_10852(about.get(a++)));
                        } else {
                            output.add(CommonImplUtils.ICON[i]);
                        }
                    }
                } else {
                    Collections.addAll(output, CommonImplUtils.ICON);
                    output.addAll(about);
                }
            } catch (Exception e) {
                e.printStackTrace();
                var invalid = class_2561.method_43470("/!\\ [ Invalid about mod info ] /!\\").method_10862(class_2583.field_24360.method_36139(0xFF0000).method_10978(true));

                output.add(invalid);
                about.add(invalid);
            }

            ABOUT_PLAYER = output.toArray(new class_2561[0]);
        }
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        var command = method_9247("polymer")
                .requires(CommonImplUtils.permission("command.core", CommonImpl.CORE_COMMAND_MINIMAL_OP))
                .executes(CommonCommands::about);

        for (var consumer : COMMANDS) {
            consumer.accept(command, access);
        }

        if (CommonImpl.DEVELOPER_MODE) {
            var dev = method_9247("dev")
                    .requires(CommonImplUtils.permission("command.dev", 3));

            for (var consumer : COMMANDS_DEV) {
                consumer.accept(dev, access);
            }

            dev.then(method_9247("is_bedrock").executes((ctx) -> {
                ctx.getSource().method_9226(() -> class_2561.method_43470("Bedrock: " + PolymerCommonUtils.isBedrockPlayer(ctx.getSource().method_44023())), false);
                return 0;
            }));

            command.then(dev);
        }

        dispatcher.register(command);
    }

    private static int about(CommandContext<class_2168> context) {
        for (var text : (context.getSource().method_9228() instanceof class_3222 ? ABOUT_PLAYER : ABOUT_COLORLESS)) {
            context.getSource().method_9226(() -> text, false);
        }

        return 0;
    }
}
