package eu.pb4.polymer.common.impl;


import eu.pb4.polymer.common.mixin.ReferenceAccessor;
import eu.pb4.polymer.common.mixin.WorldAccessor;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1535;
import net.minecraft.class_1657;
import net.minecraft.class_1845;
import net.minecraft.class_1863;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_22;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2582;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_2784;
import net.minecraft.class_2791;
import net.minecraft.class_2802;
import net.minecraft.class_2806;
import net.minecraft.class_2823;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3533;
import net.minecraft.class_3568;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_4543;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6756;
import net.minecraft.class_6760;
import net.minecraft.class_6880;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_6885;
import net.minecraft.class_7134;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_7927;
import net.minecraft.class_8108;
import net.minecraft.class_8109;
import net.minecraft.class_8110;
import net.minecraft.class_8527;
import net.minecraft.class_8528;
import net.minecraft.class_8921;
import net.minecraft.class_9209;
import net.minecraft.class_9346;
import net.minecraft.registry.*;
import net.minecraft.world.*;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

@SuppressWarnings({"rawtypes", "unchecked"})
@ApiStatus.Internal
public final class FakeWorld extends class_1937 implements class_8527 {
    public static final class_1937 INSTANCE;

    public static final class_1937 INSTANCE_UNSAFE;
    public static final class_1937 INSTANCE_REGULAR;
    static final class_269 SCOREBOARD = new class_269();

    static final class_5455 FALLBACK_REGISTRY_MANAGER = new class_5455.class_6890() {
        private static final Map<class_5321<?>, class_2378<?>> REGISTRIES = new HashMap<>();
        @Override
        public Optional<class_2378> method_33310(class_5321 key) {
            var x = class_7923.field_41167.method_29107(key);
            if (x != null) {
                return Optional.of(x);
            }

            var reg = REGISTRIES.get(key);

            if (reg != null) {
                return Optional.of(reg);
            }

            return Optional.empty();
        }

        @Override
        public Stream<class_6892<?>> method_40311() {
            return Stream.empty();
        }

        public static void addRegistry(FakeRegistry<?> registry) {
            REGISTRIES.put(registry.method_30517(), registry);
        }

        static {
            addRegistry(new FakeRegistry<>(class_7924.field_42534, class_2960.method_60655("polymer","fake_damage"),
                    new class_8110("", class_8108.field_42285, 0)));
            addRegistry(new FakeRegistry<>(class_7924.field_41252,
                    class_2960.method_60655("polymer","fake_pattern"),
                    new class_2582(class_2960.method_60655("polymer","fake_pattern"), "")));
            addRegistry(new FakeRegistry<>(class_7924.field_41209,
                    class_2960.method_60655("polymer","painting"),
                    new class_1535(1, 1, class_2960.method_60655("polymer","painting"))));
            addRegistry(new FakeRegistry<>(class_7924.field_49772,
                    class_2960.method_60655("polymer","wolf"),
                    new class_9346(class_2960.method_60655("polymer","wolf"), class_2960.method_60655("polymer","wolf"),class_2960.method_60655("polymer","wolf"), class_6885.method_58563())));
        }
    };
    static final class_1863 RECIPE_MANAGER = new class_1863(FALLBACK_REGISTRY_MANAGER);
    private static final class_7699 FEATURES = class_7701.field_40180.method_45383();
    final class_2802 chunkManager = new class_2802() {
        private class_3568 lightingProvider = null;

        @Nullable
        @Override
        public class_2791 method_12121(int x, int z, class_2806 leastStatus, boolean create) {
            return null;
        }

        @Override
        public void method_12127(BooleanSupplier shouldKeepTicking, boolean tickChunks) {

        }

        @Override
        public String method_12122() {
            return "Potato";
        }

        @Override
        public int method_14151() {
            return 0;
        }

        @Override
        public class_3568 method_12130() {
            if (this.lightingProvider == null) {
                this.lightingProvider = new class_3568(new class_2823() {
                    @Nullable
                    @Override
                    public class_8527 method_12246(int chunkX, int chunkZ) {
                        return FakeWorld.this;
                    }

                    @Override
                    public class_1922 method_16399() {
                        return FakeWorld.this;
                    }
                }, false, false);
            }

            return this.lightingProvider;
        }

        @Override
        public class_1922 method_16399() {
            return FakeWorld.this;
        }
    };
    private static final class_5577<class_1297> ENTITY_LOOKUP = new class_5577<>() {
        @Nullable
        @Override
        public class_1297 method_31804(int id) {
            return null;
        }

        @Nullable
        @Override
        public class_1297 method_31808(UUID uuid) {
            return null;
        }

        @Override
        public Iterable<class_1297> method_31803() {
            return () -> ObjectIterators.emptyIterator();
        }

        @Override
        public <U extends class_1297> void method_31806(class_5575<class_1297, U> filter, class_7927<U> consumer) {

        }

        @Override
        public void method_31807(class_238 box, Consumer<class_1297> action) {

        }

        @Override
        public <U extends class_1297> void method_31805(class_5575<class_1297, U> filter, class_238 box, class_7927<U> consumer) {

        }

    };
    private static final class_6756<?> FAKE_SCHEDULER = new class_6756<Object>() {
        @Override
        public boolean method_8677(class_2338 pos, Object type) {
            return false;
        }

        @Override
        public void method_39363(class_6760<Object> orderedTick) {

        }

        @Override
        public boolean method_8674(class_2338 pos, Object type) {
            return false;
        }

        @Override
        public int method_20825() {
            return 0;
        }
    };

    static {
        class_1937 worldUnsafe, worldDefault;

        var dimType = class_6880.class_6883.method_40233(new class_7876<>() {}, new class_2874(OptionalLong.empty(), true, false, false, true, 1.0D, true, false, -64, 384, 384, class_3481.field_25588, class_7134.field_37670, 0.0F, new class_2874.class_7512(false, true, class_6019.method_35017(0, 7), 0)));
        ((ReferenceAccessor) dimType).callSetRegistryKey(class_5321.method_29179(class_7924.field_41241, class_2960.method_60654("overworld")));
        try {
            worldUnsafe = (FakeWorld) UnsafeAccess.UNSAFE.allocateInstance(FakeWorld.class);
            var accessor = (WorldAccessor) worldUnsafe;
            accessor.polymer$setBiomeAccess(new class_4543(worldUnsafe, 1l));
            accessor.polymer$setBorder(new class_2784());
            accessor.polymer$setDebugWorld(true);
            accessor.polymer$setProfiler(() -> new class_3533(() -> 0l, () -> 0, false));
            accessor.polymer$setProperties(new FakeWorldProperties());
            accessor.polymer$setRegistryKey(class_5321.method_29179(class_7924.field_41223, class_2960.method_60655("polymer","fake_world")));
            //accessor.polymer$setDimensionKey(DimensionTypes.OVERWORLD);
            accessor.polymer$setDimensionEntry(dimType);
            accessor.polymer$setThread(Thread.currentThread());
            accessor.polymer$setRandom(class_5819.method_43047());
            accessor.polymer$setAsyncRandom(class_5819.method_43050());
            accessor.polymer$setBlockEntityTickers(new ArrayList<>());
            accessor.polymer$setPendingBlockEntityTickers(new ArrayList<>());
            try {
                accessor.polymer$setDamageSources(new class_8109(FALLBACK_REGISTRY_MANAGER));
            } catch (Throwable e) {

            }

        } catch (Throwable e) {
            CommonImpl.LOGGER.error("Creating fake world with unsafe failed...", e);
            worldUnsafe = null;
        }

        try {
            worldDefault = new FakeWorld(
                    new FakeWorldProperties(),
                    class_5321.method_29179(class_7924.field_41223, class_2960.method_60655("polymer", "fake_world")),
                    dimType,
                    () -> new class_3533(() -> 0l, () -> 0, false),
                    false,
                    true,
                    1
            );
        } catch (Throwable e) {
            CommonImpl.LOGGER.error("Creating fake world in regular way failed...", e);
            worldDefault = null;
        }


        INSTANCE_UNSAFE = worldUnsafe;
        INSTANCE_REGULAR = worldDefault;

        INSTANCE = worldUnsafe != null ? worldUnsafe : worldDefault;
    }

    private class_8921 tickManager = new class_8921();

    protected FakeWorld(class_5269 properties, class_5321<class_1937> registryRef, class_6880<class_2874> dimensionType, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long seed) {
        super(properties, registryRef, FALLBACK_REGISTRY_MANAGER, dimensionType, profiler, isClient, debugWorld, seed, 0);
    }

    @Override
    public void method_8413(class_2338 pos, class_2680 oldState, class_2680 newState, int flags) {

    }

    @Override
    public void method_8465(@Nullable class_1657 except, double x, double y, double z, class_6880<class_3414> registryEntry, class_3419 category, float volume, float pitch, long seed) {

    }

    @Override
    public void method_8449(@Nullable class_1657 except, class_1297 entity, class_6880<class_3414> registryEntry, class_3419 category, float volume, float pitch, long seed) {

    }

    @Override
    public void method_43128(@Nullable class_1657 player, double x, double y, double z, class_3414 sound, class_3419 category, float volume, float pitch) {

    }

    @Override
    public void method_43129(@Nullable class_1657 player, class_1297 entity, class_3414 sound, class_3419 category, float volume, float pitch) {

    }

    @Override
    public String method_31419() {
        return "FakeWorld!";
    }

    @Nullable
    @Override
    public class_1297 method_8469(int id) {
        return null;
    }

    @Override
    public class_8921 method_54719() {
        return this.tickManager;
    }

    @Nullable
    @Override
    public class_22 method_17891(class_9209 id) {
        return null;
    }

    @Override
    public void method_17890(class_9209 id, class_22 state) {

    }

    @Override
    public class_9209 method_17889() {
        return null;
    }

    @Override
    public void method_8517(int entityId, class_2338 pos, int progress) {

    }

    @Override
    public class_269 method_8428() {
        return SCOREBOARD;
    }

    @Override
    public class_1863 method_8433() {
        return RECIPE_MANAGER;
    }

    @Override
    protected class_5577<class_1297> method_31592() {
        return ENTITY_LOOKUP;
    }

    @Override
    public class_6756<class_2248> method_8397() {
        return (class_6756<class_2248>) FAKE_SCHEDULER;
    }

    @Override
    public class_6756<class_3611> method_8405() {
        return (class_6756<class_3611>) FAKE_SCHEDULER;
    }

    @Override
    public class_2802 method_8398() {
        return chunkManager;
    }

    @Override
    public void method_8444(@Nullable class_1657 player, int eventId, class_2338 pos, int data) {

    }

    @Override
    public void method_32888(class_6880<class_5712> event, class_243 emitterPos, class_5712.class_7397 emitter) {

    }
    @Override
    public class_5455 method_30349() {
        return FALLBACK_REGISTRY_MANAGER;
    }

    @Override
    public class_1845 method_59547() {
        return null;
    }

    @Override
    public class_7699 method_45162() {
        return FEATURES;
    }

    @Override
    public float method_24852(class_2350 direction, boolean shaded) {
        return 0;
    }

    @Override
    public List<? extends class_1657> method_18456() {
        return Collections.emptyList();
    }

    @Override
    public class_6880<class_1959> method_22387(int biomeX, int biomeY, int biomeZ) {
        return null;//BuiltinRegistries.BIOME.getEntry(BiomeKeys.THE_VOID).get();
    }

    @Override
    public void method_51524(BiConsumer<class_2338, class_2680> callback) {

    }

    @Override
    public class_8528 method_12018() {
        return null;
    }


    static class FakeWorldProperties implements class_5269 {
        @Override
        public class_2338 method_56126() {
            return class_2338.field_10980;
        }

        @Override
        public float method_30656() {
            return 0;
        }

        @Override
        public long method_188() {
            return 0;
        }

        @Override
        public long method_217() {
            return 0;
        }

        @Override
        public boolean method_203() {
            return false;
        }

        @Override
        public boolean method_156() {
            return false;
        }

        @Override
        public void method_157(boolean raining) {

        }

        @Override
        public boolean method_152() {
            return false;
        }

        @Override
        public class_1928 method_146() {
            return new class_1928();
        }

        @Override
        public class_1267 method_207() {
            return class_1267.field_5802;
        }

        @Override
        public boolean method_197() {
            return false;
        }

        @Override
        public void method_187(class_2338 pos, float angle) {

        }
    }
}
