package eu.pb4.polymer.common.mixin;

import eu.pb4.polymer.common.api.PolymerCommonUtils;
import eu.pb4.polymer.common.impl.CommonClientConnectionExt;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonNetworkHandlerExt;
import net.minecraft.class_2535;
import net.minecraft.class_2856;
import net.minecraft.class_8609;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_8609.class)
public abstract class ServerCommonNetworkHandlerMixin implements CommonNetworkHandlerExt {
    @Shadow @Final protected class_2535 connection;
    @Unique
    private boolean polymerCommon$ignoreNextStatus = false;

    @Inject(method = "onResourcePackStatus", at = @At("TAIL"))
    private void polymer$changeStatus(class_2856 packet, CallbackInfo ci) {
        if (!CommonImplUtils.disableResourcePackCheck) {
            if (!this.polymerCommon$ignoreNextStatus) {
                ((CommonClientConnectionExt) this.connection).polymerCommon$setResourcePack(packet.comp_2163(), switch (packet.comp_2164()) {
                    case field_13017, field_47704, field_13016 -> true;
                    case field_13018, field_13015, field_47667, field_47668, field_47669 -> false;
                });
            }

            this.polymerCommon$ignoreNextStatus = false;
        }
    }

    @Override
    public void polymerCommon$setIgnoreNextResourcePack() {
        this.polymerCommon$ignoreNextStatus = true;
    }

    @Override
    public class_2535 polymerCommon$getConnection() {
        return this.connection;
    }
}
