/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.common.impl.entity;

import com.mojang.authlib.GameProfile;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.common.impl.FakeWorld;
import eu.pb4.polymer.common.impl.entity.FakeEntity;
import eu.pb4.polymer.common.mixin.DataTrackerAccessor;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.disguiselib.api.EntityDisguise;

@ApiStatus.Internal
public class InternalEntityHelpers {
    private static final Map<class_1299<?>, @Nullable class_1297> EXAMPLE_ENTITIES = new HashMap();
    private static final Map<class_1299<?>, class_2945.class_2946<?>[]> TRACKED_DATA = new Object2ObjectOpenCustomHashMap(CommonImplUtils.IDENTITY_HASH);

    private static class_1657 createPlayer() {
        class_1657 player;
        block5: {
            player = null;
            try {
                player = new class_1657(FakeWorld.INSTANCE_UNSAFE, class_2338.field_10980, 0.0f, new GameProfile(class_156.field_25140, "TinyPotato")){

                    public boolean method_7325() {
                        return false;
                    }

                    public boolean method_7337() {
                        return false;
                    }
                };
            }
            catch (Throwable e) {
                if (CommonImpl.LOG_MORE_ERRORS) {
                    CommonImpl.LOGGER.error("Failed add player like entity! Trying with alternative method", e);
                }
                try {
                    player = new class_1657(FakeWorld.INSTANCE_REGULAR, class_2338.field_10980, 0.0f, new GameProfile(class_156.field_25140, "TinyPotato")){

                        public boolean method_7325() {
                            return false;
                        }

                        public boolean method_7337() {
                            return false;
                        }
                    };
                }
                catch (Throwable e2) {
                    if (!CommonImpl.LOG_MORE_ERRORS) break block5;
                    CommonImpl.LOGGER.error("Failed add player like entity!", e2);
                }
            }
        }
        EXAMPLE_ENTITIES.put(class_1299.field_6097, (class_1297)player);
        return player;
    }

    public static class_2945.class_2946<?>[] getExampleTrackedDataOfEntityType(class_1299<?> type) {
        class_1297 ent;
        class_2945.class_2946<?>[] val = TRACKED_DATA.get(type);
        if (val == null && (ent = InternalEntityHelpers.getEntity(type)) != null) {
            class_2945.class_2946<?>[] map = ((DataTrackerAccessor)ent.method_5841()).getEntries();
            TRACKED_DATA.put(type, map);
            return map;
        }
        return val;
    }

    public static <T extends class_1297> Class<T> getEntityClass(class_1299<T> type) {
        return InternalEntityHelpers.getEntity(type).getClass();
    }

    public static boolean isLivingEntity(class_1299<?> type) {
        return InternalEntityHelpers.getEntity(type) instanceof class_1309;
    }

    public static boolean isMobEntity(class_1299<?> type) {
        return InternalEntityHelpers.getEntity(type) instanceof class_1308;
    }

    public static boolean canPatchTrackedData(class_3222 player, class_1297 entity) {
        if (CompatStatus.DISGUISELIB) {
            return !((EntityDisguise)entity).isDisguised() || ((EntityDisguise)player).hasTrueSight();
        }
        return true;
    }

    public static class_1297 getEntity(class_1299<?> type) {
        class_1297 entity = EXAMPLE_ENTITIES.get(type);
        if (entity == null) {
            if (type == class_1299.field_6097) {
                return InternalEntityHelpers.createPlayer();
            }
            try {
                entity = type.method_5883(FakeWorld.INSTANCE_UNSAFE);
            }
            catch (Throwable e) {
                try {
                    entity = type.method_5883(FakeWorld.INSTANCE_REGULAR);
                }
                catch (Throwable e2) {
                    class_2960 id = class_7923.field_41177.method_10221(type);
                    if (CommonImpl.ENABLE_TEMPLATE_ENTITY_WARNINGS) {
                        CommonImpl.LOGGER.warn(String.format("Couldn't create template entity of %s... Defaulting to empty. %s", id, id.method_12836().equals("minecraft") ? "This might cause problems!" : "Don't worry, this shouldn't cause problems!"));
                        if (id.method_12836().equals("minecraft")) {
                            CommonImpl.LOGGER.warn("First error:");
                            e.printStackTrace();
                            CommonImpl.LOGGER.warn("Second error:");
                            e2.printStackTrace();
                        }
                    }
                    entity = FakeEntity.INSTANCE;
                }
            }
            EXAMPLE_ENTITIES.put(type, entity);
        }
        return entity;
    }

    public static class_1297 getFakeEntity() {
        return FakeEntity.INSTANCE;
    }
}

