package eu.pb4.polymer.core.mixin.item;

import eu.pb4.polymer.core.api.item.PolymerItemGroupUtils;
import eu.pb4.polymer.core.api.utils.PolymerObject;
import eu.pb4.polymer.core.impl.PolymerImplUtils;
import eu.pb4.polymer.core.impl.interfaces.ItemGroupExtra;
import eu.pb4.polymer.core.impl.other.ItemGroupEntriesImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;

@Mixin(value = class_1761.class, priority = 800)
public abstract class ItemGroupMixin implements ItemGroupExtra {
    @Shadow @Final private class_1761.class_7914 entryCollector;

    @Shadow private Collection<class_1799> displayStacks;

    @Shadow private Set<class_1799> searchTabStacks;

    @Override
    public PolymerItemGroupUtils.Contents polymer$getContentsWith(class_2960 id, class_7699 enabledFeatures, boolean operatorEnabled, class_7225.class_7874 lookup) {
        var collector = new ItemGroupEntriesImpl((class_1761) (Object) this, enabledFeatures);
        var context = new class_1761.class_8128(enabledFeatures, operatorEnabled, lookup);
        this.entryCollector.accept(context, collector);
        var parent = new LinkedList<>(collector.parentTabStacks);
        var search = new LinkedList<>(collector.searchTabStacks);
        PolymerImplUtils.callItemGroupEvents(id, (class_1761) (Object) this, parent, search, context);
        parent.removeIf(class_1799::method_7960);
        search.removeIf(class_1799::method_7960);
        return new PolymerItemGroupUtils.Contents(parent, search);
    }

    @ModifyArg(method = "updateEntries", at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/Registry;getKey(Ljava/lang/Object;)Ljava/util/Optional;"))
    private Object polymerCore$bypassServerSide(Object entry) {
        return PolymerItemGroupUtils.isPolymerItemGroup((class_1761) entry) ? class_7706.method_47328() : entry;
    }

    @Inject(method = "updateEntries", at = @At(value = "TAIL"), cancellable = true)
    private void polymerCore$bypassFabricApiBS(class_1761.class_8128 displayContext, CallbackInfo ci) {
        if (PolymerItemGroupUtils.isPolymerItemGroup((class_1761) (Object) this) || this instanceof PolymerObject) {
            var parent = new LinkedList<>(this.displayStacks);
            var search = new LinkedList<>(this.searchTabStacks);
            PolymerImplUtils.callItemGroupEvents(PolymerItemGroupUtils.getId((class_1761) (Object) this), (class_1761) (Object) this, parent, search, displayContext);
            this.displayStacks.clear();
            this.displayStacks.addAll(parent);
            this.searchTabStacks.clear();
            this.searchTabStacks.addAll(search);
            ci.cancel();
        }
    }
}
