/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.core.api.entity;

import eu.pb4.polymer.common.api.events.BooleanEvent;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.entity.InternalEntityHelpers;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.core.api.item.PolymerItem;
import eu.pb4.polymer.core.api.utils.PolymerSyncedObject;
import eu.pb4.polymer.core.impl.entity.OneOfPolymerEntityConstructors;
import eu.pb4.polymer.core.impl.interfaces.EntityAttachedPacket;
import eu.pb4.polymer.core.impl.interfaces.PolymerEntityProvider;
import eu.pb4.polymer.core.impl.networking.PolymerServerProtocol;
import eu.pb4.polymer.core.mixin.block.packet.ServerChunkLoadingManagerAccessor;
import eu.pb4.polymer.core.mixin.entity.EntityAccessor;
import eu.pb4.polymer.core.mixin.entity.EntityTrackerAccessor;
import eu.pb4.polymer.core.mixin.entity.PlayerListS2CPacketAccessor;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2703;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class PolymerEntityUtils {
    public static final BooleanEvent<PolymerEntityInteractionListener> POLYMER_ENTITY_INTERACTION_CHECK = new BooleanEvent();
    private static final Map<class_1299<?>, Function<class_1297, PolymerEntity>> POLYMER_ENTITY_CONSTRUCTORS = new IdentityHashMap();
    private static final Set<class_1320> ENTITY_ATTRIBUTES = new ObjectOpenCustomHashSet(CommonImplUtils.IDENTITY_HASH);

    private PolymerEntityUtils() {
    }

    public static int requestFreeId() {
        return EntityAccessor.getCURRENT_ID().incrementAndGet();
    }

    public static void registerType(class_1299<?> ... types) {
        for (class_1299<?> type : types) {
            PolymerEntityUtils.registerPolymerEntityConstructor(type, entity -> {
                PolymerEntity polymerEntity;
                return entity instanceof PolymerEntity ? (polymerEntity = (PolymerEntity)entity) : null;
            });
        }
        for (class_1299<?> type : types) {
            PolymerSyncedObject.setSyncedObject(class_7923.field_41177, type, (ent, ctx) -> class_1299.field_33456);
        }
    }

    public static void registerType(class_1299<?> type, PolymerSyncedObject<class_1299<?>> syncedObject) {
        PolymerEntityUtils.registerPolymerEntityConstructor(type, entity -> {
            PolymerEntity polymerEntity;
            return entity instanceof PolymerEntity ? (polymerEntity = (PolymerEntity)entity) : context -> syncedObject.getPolymerReplacement(entity.method_5864(), context);
        });
        PolymerSyncedObject.setSyncedObject(class_7923.field_41177, type, syncedObject);
    }

    public static <T extends class_1297> void registerOverlay(class_1299<T> type, Function<T, PolymerEntity> constructor) {
        PolymerEntityUtils.registerPolymerEntityConstructor(type, constructor);
        PolymerSyncedObject.setSyncedObject(class_7923.field_41177, type, (ent, ctx) -> class_1299.field_33456);
    }

    public static <T extends class_1297> void registerOverlay(class_1299<T> type, PolymerSyncedObject<class_1299<?>> syncedObject, Function<T, PolymerEntity> constructor) {
        PolymerEntityUtils.registerPolymerEntityConstructor(type, constructor);
        PolymerSyncedObject.setSyncedObject(class_7923.field_41177, type, syncedObject);
    }

    public static <T extends class_1297> void registerPolymerEntityConstructor(class_1299<T> type, Function<T, @Nullable PolymerEntity> constructor) {
        if (POLYMER_ENTITY_CONSTRUCTORS.containsKey(type)) {
            Function<class_1297, PolymerEntity> old = POLYMER_ENTITY_CONSTRUCTORS.get(type);
            POLYMER_ENTITY_CONSTRUCTORS.put(type, new OneOfPolymerEntityConstructors<class_1297>(constructor, old));
        } else {
            POLYMER_ENTITY_CONSTRUCTORS.put(type, constructor);
        }
    }

    @Nullable
    public static <T extends class_1297> @Nullable Function<T, @Nullable PolymerEntity> getPolymerEntityConstructor(class_1299<T> type) {
        return POLYMER_ENTITY_CONSTRUCTORS.get(type);
    }

    @SafeVarargs
    public static void registerAttribute(class_6880<class_1320> ... attributes) {
        for (class_6880<class_1320> type : attributes) {
            ENTITY_ATTRIBUTES.add((class_1320)type.comp_349());
            RegistrySyncUtils.setServerEntry((class_2378)class_7923.field_41190, (Object)((class_1320)type.comp_349()));
        }
    }

    public static void registerProfession(class_3852 profession, PolymerSyncedObject<class_3852> mapper) {
        PolymerSyncedObject.setSyncedObject(class_7923.field_41195, profession, mapper);
    }

    @Nullable
    public static PolymerSyncedObject<class_3852> getPolymerProfession(class_3852 profession) {
        return PolymerSyncedObject.getSyncedObject(class_7923.field_41195, profession);
    }

    public static boolean isPolymerEntityType(class_1299<?> type) {
        return PolymerSyncedObject.getSyncedObject(class_7923.field_41177, type) != null;
    }

    public static boolean isPolymerEntityAttribute(class_6880<class_1320> type) {
        return ENTITY_ATTRIBUTES.contains(type.comp_349());
    }

    public static class_2945.class_2946<?>[] getDefaultTrackedData(class_1299<?> type) {
        return InternalEntityHelpers.getExampleTrackedDataOfEntityType(type);
    }

    public static <T extends class_1297> Class<T> getEntityClass(class_1299<T> type) {
        return InternalEntityHelpers.getEntityClass(type);
    }

    public static boolean isLivingEntity(class_1299<?> type) {
        return InternalEntityHelpers.isLivingEntity(type);
    }

    public static boolean isMobEntity(class_1299<?> type) {
        return InternalEntityHelpers.isMobEntity(type);
    }

    public static class_2703 createMutablePlayerListPacket(EnumSet<class_2703.class_5893> actions) {
        class_2703 packet = new class_2703(actions, List.of());
        ((PlayerListS2CPacketAccessor)packet).setEntries(new ArrayList<class_2703.class_2705>());
        return packet;
    }

    public static boolean canHoldEntityContext(class_2596<?> packet) {
        return packet instanceof EntityAttachedPacket;
    }

    public static <T extends class_2596<class_2602>> T setEntityContext(T packet, class_1297 entity) {
        return EntityAttachedPacket.setIfEmpty(packet, entity);
    }

    public static <T extends class_2596<class_2602>> T forceSetEntityContext(T packet, class_1297 entity) {
        return EntityAttachedPacket.set(packet, entity);
    }

    @Nullable
    public static class_1297 getEntityContext(class_2596<?> packet) {
        return EntityAttachedPacket.get(packet);
    }

    public static void sendEntityType(class_3222 player, int entityId, class_1299<?> entityType) {
        PolymerServerProtocol.sendEntityInfo(player.field_13987, entityId, entityType);
    }

    public static void recreatePolymerEntity(class_1297 entity) {
        ((PolymerEntityProvider)entity).polymer$recreatePolymerEntity();
    }

    @ApiStatus.Experimental
    public static void setPolymerEntity(class_1297 entity, PolymerEntity polymerEntity) {
        ((PolymerEntityProvider)entity).polymer$setPolymerEntity(polymerEntity);
    }

    public static void refreshEntity(class_3222 player, class_1297 entity) {
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_3898.class_3208 tracker = (class_3898.class_3208)((ServerChunkLoadingManagerAccessor)world.method_14178().field_17254).polymer$getEntityTrackers().get(entity.method_5628());
            if (tracker != null) {
                tracker.method_18733(player);
                tracker.method_18736(player);
            }
        }
    }

    public static void refreshEntity(class_1297 entity) {
        class_1937 class_19372 = entity.method_73183();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            class_3898.class_3208 tracker = (class_3898.class_3208)((ServerChunkLoadingManagerAccessor)world.method_14178().field_17254).polymer$getEntityTrackers().get(entity.method_5628());
            if (tracker != null) {
                for (class_5629 player : ((EntityTrackerAccessor)tracker).getListeners()) {
                    ((EntityTrackerAccessor)tracker).getEntry().method_14302(player.method_32311());
                    ((EntityTrackerAccessor)tracker).getEntry().method_18760(player.method_32311());
                }
            }
        }
    }

    public static boolean isPolymerEntityInteraction(class_3222 player, class_1268 hand, class_1799 stack, class_3218 world, class_1297 entity, class_1269 actionResult) {
        PolymerItem polymerItem;
        PolymerEntity polymerEntity = PolymerEntity.get(entity);
        if (polymerEntity != null && polymerEntity.isPolymerEntityInteraction(player, hand, stack, world, actionResult)) {
            return true;
        }
        PolymerSyncedObject<class_1792> polymerSyncedObject = PolymerSyncedObject.getSyncedObject(class_7923.field_41178, stack.method_7909());
        if (polymerSyncedObject instanceof PolymerItem && (polymerItem = (PolymerItem)polymerSyncedObject).isPolymerEntityInteraction(player, hand, stack, world, entity, actionResult)) {
            return true;
        }
        return POLYMER_ENTITY_INTERACTION_CHECK.invoke(x -> x.isPolymerEntityInteraction(player, hand, stack, world, entity, actionResult));
    }

    public static <T extends class_1297> void registerOverlay(class_1299<T> type, it.unimi.dsi.fastutil.Function<T, PolymerEntity> constructor) {
        PolymerEntityUtils.registerOverlay(type, constructor);
    }

    public static <T extends class_1297> void registerOverlay(class_1299<T> type, PolymerSyncedObject<class_1299<?>> syncedObject, it.unimi.dsi.fastutil.Function<T, PolymerEntity> constructor) {
        PolymerEntityUtils.registerOverlay(type, syncedObject, constructor);
    }

    @FunctionalInterface
    public static interface PolymerEntityInteractionListener {
        public boolean isPolymerEntityInteraction(class_3222 var1, class_1268 var2, class_1799 var3, class_3218 var4, class_1297 var5, class_1269 var6);
    }
}

